/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.paper.command;

import com.convallyria.forcepack.paper.ForcePackPaper;
import com.convallyria.forcepack.paper.command.ForcePackCommand;
import forcepack.libs.paper.cloud.SenderMapper;
import forcepack.libs.paper.cloud.annotations.AnnotationParser;
import forcepack.libs.paper.cloud.bukkit.CloudBukkitCapabilities;
import forcepack.libs.paper.cloud.execution.ExecutionCoordinator;
import forcepack.libs.paper.cloud.paper.LegacyPaperCommandManager;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class Commands {
    public Commands(ForcePackPaper plugin) {
        LegacyPaperCommandManager manager;
        try {
            manager = new LegacyPaperCommandManager((Plugin)plugin, ExecutionCoordinator.simpleCoordinator(), SenderMapper.identity());
        }
        catch (Exception e) {
            plugin.getLogger().severe("Failed to initialize the command manager");
            e.printStackTrace();
            return;
        }
        try {
            if (manager.hasCapability(CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
                manager.registerBrigadier();
            } else if (manager.hasCapability(CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
                manager.registerAsynchronousCompletions();
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("Failed to register brigadier/asynchronous completions, your server software is lying about its capabilities!");
        }
        AnnotationParser<CommandSender> annotationParser = new AnnotationParser<CommandSender>(manager, CommandSender.class);
        annotationParser.parse(new ForcePackCommand(plugin));
    }
}

