/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.paper.resourcepack;

import com.convallyria.forcepack.api.resourcepack.ResourcePack;
import com.convallyria.forcepack.api.resourcepack.ResourcePackVersion;
import com.convallyria.forcepack.paper.ForcePackPaper;
import com.convallyria.forcepack.paper.libs.adventure.adventure.text.Component;
import com.convallyria.forcepack.paper.libs.adventure.adventure.text.JoinConfiguration;
import com.convallyria.forcepack.paper.translation.Translations;
import com.convallyria.forcepack.paper.util.ProtocolUtil;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerResourcePackSend;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PaperResourcePack
extends ResourcePack {
    private final ForcePackPaper paperPlugin;

    public PaperResourcePack(ForcePackPaper plugin, String url, String hash, int size, @Nullable ResourcePackVersion packVersion) {
        this(plugin, Bukkit.getServer().getName(), url, hash, size, packVersion);
    }

    public PaperResourcePack(ForcePackPaper plugin, String server, String url, String hash, int size, @Nullable ResourcePackVersion packVersion) {
        super(plugin, server, url, hash, size, packVersion);
        this.paperPlugin = plugin;
    }

    @Override
    public void setResourcePack(UUID uuid) {
        int delay = this.paperPlugin.getConfig().getInt("delay-pack-sending-by", 0);
        if (delay > 0) {
            this.plugin.getScheduler().executeDelayed(() -> this.runSetResourcePack(uuid), delay);
        } else {
            this.runSetResourcePack(uuid);
        }
    }

    private void runSetResourcePack(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return;
        }
        this.paperPlugin.getForcePackPlayer(player).ifPresent(forcePackPlayer -> forcePackPlayer.getChecks().forEach(check -> check.sendPack(this)));
        WrapperPlayServerResourcePackSend send = new WrapperPlayServerResourcePackSend(this.getUUID(), this.url, this.getHash(), this.paperPlugin.getConfig().getBoolean("use-new-force-pack-screen", true), Component.join(JoinConfiguration.newlines(), Translations.PROMPT_TEXT.getProper(player)));
        ProtocolUtil.sendPacketBypassingVia(player, send);
    }
}

