/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.paper.translation;

import com.convallyria.forcepack.paper.ForcePackPaper;
import com.convallyria.forcepack.paper.libs.adventure.adventure.platform.bukkit.BukkitComponentSerializer;
import com.convallyria.forcepack.paper.libs.adventure.adventure.text.Component;
import com.convallyria.forcepack.paper.libs.languagy.api.language.Language;
import com.convallyria.forcepack.paper.libs.languagy.api.language.key.TranslationKey;
import com.convallyria.forcepack.paper.libs.languagy.api.language.translation.Translation;
import java.io.File;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public enum Translations {
    DECLINED(TranslationKey.of("declined")),
    ACCEPTED(TranslationKey.of("accepted")),
    DOWNLOAD_START_TITLE(TranslationKey.of("download_start_title")),
    DOWNLOAD_START_SUBTITLE(TranslationKey.of("download_start_subtitle")),
    DOWNLOAD_FAILED(TranslationKey.of("download_failed")),
    PROMPT_TEXT(TranslationKey.of("prompt_text")),
    RELOADING(TranslationKey.of("reloading"));

    private final TranslationKey key;

    private Translations(TranslationKey key) {
        this.key = key;
    }

    public TranslationKey getKey() {
        return this.key;
    }

    public void send(Player player, Object ... values) {
        Translation message = this.getTranslation(player);
        message.format(values);
        message.send();
    }

    public List<Component> getProper(Player player) {
        return this.getTranslation(player).colour();
    }

    @Deprecated
    public String get(Player player) {
        return BukkitComponentSerializer.legacy().serialize(this.getTranslation(player).colour().get(0));
    }

    public Translation getTranslation(Player player) {
        return ForcePackPaper.getInstance().getTranslator().getTranslationFor(player, this.key);
    }

    public static void generateLang(ForcePackPaper plugin) {
        File lang = new File(String.valueOf(plugin.getDataFolder()) + "/lang/");
        lang.mkdirs();
        for (Language language : Language.values()) {
            try {
                if (!new File(String.valueOf(lang) + File.separator + language.getKey().getCode() + ".yml").exists()) {
                    plugin.saveResource("lang/" + language.getKey().getCode() + ".yml", false);
                }
                plugin.getLogger().info("Generated " + language.getKey().getCode() + ".yml");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            File file = new File(String.valueOf(plugin.getDataFolder()) + "/lang/" + language.getKey().getCode() + ".yml");
            if (!file.exists()) continue;
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            for (Translations key : Translations.values()) {
                if (config.get(key.toString().toLowerCase()) != null) continue;
                plugin.getLogger().warning("No value in translation file for key " + String.valueOf((Object)key) + " was found. Regenerate language files?");
            }
        }
    }
}

