/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.webserver;

import com.convallyria.forcepack.libs.javalin.Javalin;
import com.convallyria.forcepack.libs.javalin.http.HttpStatus;
import com.convallyria.forcepack.libs.javalin.util.JavalinLogger;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;

public class ForcePackWebServer {
    private final Javalin app;
    private final Path dataFolder;
    private final String ipAddress;
    private final int port;
    private final Map<File, String> hostedPacks = new HashMap<File, String>();
    private final Cache<String, Runnable> waitingServes = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).build();

    public ForcePackWebServer(Path dataFolder, String serverIp, int port) throws IOException {
        JavalinLogger.enabled = false;
        JavalinLogger.startupInfo = false;
        this.app = Javalin.create(config -> {
            config.showJavalinBanner = false;
        }).start(port);
        this.dataFolder = dataFolder;
        this.setupEndpoints();
        this.ipAddress = serverIp;
        this.port = port;
    }

    public void addHostedPack(File hostedPack) {
        try {
            this.hostedPacks.put(hostedPack, Files.asByteSource((File)hostedPack).hash(Hashing.sha1()).toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void clearHostedPacks() {
        this.hostedPacks.clear();
    }

    public void shutdown() {
        this.app.stop();
    }

    public String getUrl() {
        return "http://" + this.ipAddress + ":" + this.port;
    }

    public String getHostedEndpoint(String urlString) {
        File targetFile = new File(String.valueOf(this.dataFolder) + File.separator + urlString.replace("forcepack://", ""));
        return this.getUrl() + "/serve/" + this.hostedPacks.get(targetFile) + ".zip";
    }

    public void awaitServe(String id, Runnable runnable) {
        this.waitingServes.put((Object)id, (Object)runnable);
    }

    private void setupEndpoints() {
        this.app.get("/", ctx -> ctx.status(HttpStatus.NO_CONTENT));
        this.app.get("/serve/<id>", ctx -> {
            String id = ctx.pathParam("id");
            for (File hostedPack : this.hostedPacks.keySet()) {
                if (!id.equals(this.hostedPacks.get(hostedPack) + ".zip")) continue;
                byte[] fileBytes = Files.asByteSource((File)hostedPack).read();
                ctx.result(fileBytes).header("X-Hosted-By", "forcepack").header("Content-Type", "application/zip").header("Content-Disposition", "attachment; filename=" + hostedPack.getName());
                return;
            }
            ctx.status(HttpStatus.OK).header("X-Hosted-By", "forcepack").header("Content-Type", "application/zip").header("Content-Disposition", "attachment; filename=" + id);
            Runnable runnable = (Runnable)this.waitingServes.getIfPresent((Object)id);
            this.waitingServes.invalidate((Object)id);
            if (runnable != null) {
                runnable.run();
            }
        });
    }

    public static String getIp() {
        try {
            URL url = new URL("https://api.ipify.org");
            InputStream stream = url.openStream();
            Scanner s = new Scanner(stream, StandardCharsets.UTF_8).useDelimiter("\\A");
            String ip = s.next();
            s.close();
            stream.close();
            return ip;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "localhost";
        }
    }
}

