/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.velocity.cloud.util.annotation;

import forcepack.libs.velocity.cloud.util.annotation.AnnotatedElementAccessor;
import forcepack.libs.velocity.cloud.util.annotation.MultiDelegateAnnotationAccessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Collections;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.STABLE)
public interface AnnotationAccessor {
    @API(status=API.Status.STABLE)
    public static @NonNull AnnotationAccessor empty() {
        return new NullAnnotationAccessor();
    }

    public static @NonNull AnnotationAccessor of(@NonNull AnnotatedElement element) {
        return new AnnotatedElementAccessor(element);
    }

    @API(status=API.Status.STABLE)
    public static @NonNull AnnotationAccessor of(AnnotationAccessor ... accessors) {
        return new MultiDelegateAnnotationAccessor(accessors);
    }

    public <A extends Annotation> @Nullable A annotation(@NonNull Class<A> var1);

    public @NonNull Collection<@NonNull Annotation> annotations();

    @API(status=API.Status.INTERNAL, consumers={"forcepack.libs.velocity.cloud.*"})
    public static final class NullAnnotationAccessor
    implements AnnotationAccessor {
        @Override
        public <A extends Annotation> @Nullable A annotation(@NonNull Class<A> clazz) {
            return null;
        }

        @Override
        public @NonNull Collection<@NonNull Annotation> annotations() {
            return Collections.emptyList();
        }
    }
}

