/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.velocity;

import com.convallyria.forcepack.api.ForcePackPlatform;
import com.convallyria.forcepack.api.resourcepack.PackFormatResolver;
import com.convallyria.forcepack.api.resourcepack.ResourcePack;
import com.convallyria.forcepack.api.resourcepack.ResourcePackVersion;
import com.convallyria.forcepack.api.schedule.PlatformScheduler;
import com.convallyria.forcepack.api.utils.ClientVersion;
import com.convallyria.forcepack.api.utils.GeyserUtil;
import com.convallyria.forcepack.api.utils.HashingUtil;
import com.convallyria.forcepack.api.verification.ResourcePackURLData;
import com.convallyria.forcepack.velocity.command.Commands;
import com.convallyria.forcepack.velocity.config.VelocityConfig;
import com.convallyria.forcepack.velocity.handler.PackHandler;
import com.convallyria.forcepack.velocity.libs.bstats.velocity.Metrics;
import com.convallyria.forcepack.velocity.listener.ResourcePackListener;
import com.convallyria.forcepack.velocity.resourcepack.VelocityResourcePack;
import com.convallyria.forcepack.velocity.schedule.VelocityScheduler;
import com.convallyria.forcepack.webserver.ForcePackWebServer;
import com.convallyria.forcepack.webserver.downloader.WebServerDependencyDownloader;
import com.google.inject.Inject;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.event.EventManager;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;

@Plugin(id="forcepack", name="ForcePack", version="1.3.72", description="Force players to use your server resource pack.", url="https://www.convallyria.com", dependencies={@Dependency(id="viaversion", optional=true), @Dependency(id="viabackwards", optional=true), @Dependency(id="viarewind", optional=true)}, authors={"SamB440"})
public class ForcePackVelocity
implements ForcePackPlatform {
    public static final String EMPTY_SERVER_NAME = "ForcePack-Empty-Server";
    public static final String GLOBAL_SERVER_NAME = "ForcePack-Global-Server";
    private final ProxyServer server;
    private final Logger logger;
    private final Commands commands;
    private final Path dataDirectory;
    private final Metrics.Factory metricsFactory;
    private final CommandManager commandManager;
    private final VelocityScheduler scheduler;
    private ForcePackWebServer webServer;
    public final Set<UUID> temporaryExemptedPlayers = new HashSet<UUID>();
    private VelocityConfig config;
    private PackHandler packHandler;
    private final Set<ResourcePack> globalResourcePacks = new HashSet<ResourcePack>();
    private final Set<ResourcePack> resourcePacks = new HashSet<ResourcePack>();
    private MiniMessage miniMessage;

    public Optional<ForcePackWebServer> getWebServer() {
        return Optional.ofNullable(this.webServer);
    }

    @Inject
    public ForcePackVelocity(PluginContainer container, ProxyServer server, Logger logger, @DataDirectory Path dataDirectory, Metrics.Factory metricsFactory, CommandManager commandManager) {
        this.server = server;
        this.logger = logger;
        this.commands = new Commands(this, container);
        this.dataDirectory = dataDirectory;
        this.metricsFactory = metricsFactory;
        this.commandManager = commandManager;
        this.scheduler = new VelocityScheduler(this);
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.getLogger().info("Enabling ForcePack (velocity)...");
        GeyserUtil.isGeyserInstalledHere = this.server.getPluginManager().getPlugin("geyser").isPresent();
        this.reloadConfig();
        VelocityConfig webServerConfig = this.getConfig().getConfig("web-server");
        if (webServerConfig != null && webServerConfig.getBoolean("enabled")) {
            try {
                this.getLogger().info("Enabling web server...");
                this.getLogger().info("Downloading required dependencies, this might take a while! Subsequent startups will be faster.");
                WebServerDependencyDownloader.download(this, this.getDataDirectory(), x$0 -> this.log((String)x$0, new Object[0]));
                this.getLogger().info("Finished downloading required dependencies.");
                String configIp = webServerConfig.getString("server-ip", "localhost");
                String serverIp = !configIp.equals("localhost") ? configIp : ForcePackWebServer.getIp();
                this.webServer = new ForcePackWebServer(this.dataDirectory, webServerConfig.getString("protocol", "http://"), serverIp, webServerConfig.getInt("port", 8080), webServerConfig.getBoolean("port-on-url", true));
                this.getLogger().info("Started web server.");
            }
            catch (IOException e) {
                this.getLogger().error("Error starting web server: {}", (Object)e.getMessage());
                this.getLogger().error("It is highly likely you need to open a port or change it in the config. Please see the config for further information.");
                return;
            }
        }
        this.packHandler = new PackHandler(this);
        this.loadResourcePacks(null);
        this.registerListeners();
        this.metricsFactory.make(this, 13678);
    }

    @Subscribe
    public void onShutdown(ProxyShutdownEvent event) {
        if (this.webServer != null) {
            this.webServer.shutdown();
        }
    }

    private void createConfig() {
        Path dirPath = Path.of(String.valueOf(this.dataDirectory) + File.separator, new String[0]);
        File dirFile = dirPath.toFile();
        if (!dirFile.exists()) {
            dirFile.mkdirs();
            try {
                Path configPath = Path.of(String.valueOf(this.dataDirectory) + File.separator + "config.toml", new String[0]);
                Files.copy(this.getClass().getResourceAsStream("/config.toml"), configPath, new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void reloadConfig() {
        this.createConfig();
        this.config = new VelocityConfig(this);
    }

    private void registerListeners() {
        EventManager eventManager = this.server.getEventManager();
        eventManager.register((Object)this, (Object)new ResourcePackListener(this));
        if (!this.getConfig().getBoolean("disable-commands-until-loaded", false)) {
            return;
        }
        eventManager.register((Object)this, CommandExecuteEvent.class, event -> {
            if (event.getCommandSource() instanceof Player) {
                Player player = (Player)event.getCommandSource();
                String command = event.getCommand();
                if (this.getConfig().getStringList("exclude-commands").contains(command)) {
                    return;
                }
                if (this.packHandler.isWaiting(player)) {
                    this.log("Stopping command '%s' because player has not loaded all their resource packs yet.", command);
                    event.setResult(CommandExecuteEvent.CommandResult.denied());
                }
            }
        });
    }

    public void loadResourcePacks(@Nullable Player player) {
        this.resourcePacks.clear();
        this.globalResourcePacks.clear();
        this.getWebServer().ifPresent(ForcePackWebServer::clearHostedPacks);
        this.checkUnload();
        this.checkGlobal();
        boolean verifyPacks = this.getConfig().getBoolean("verify-resource-packs");
        VelocityConfig groups = this.getConfig().getConfig("groups");
        if (groups != null) {
            this.addResourcePacks(player, "groups");
        }
        this.addResourcePacks(player, "servers");
        if (!verifyPacks) {
            this.logger.info("Loaded {} resource packs without verification.", (Object)this.resourcePacks.size());
            return;
        }
        ConsoleCommandSource consoleSender = this.getServer().getConsoleCommandSource();
        Component loadedMsg = Component.text((String)("Loaded " + this.resourcePacks.size() + " verified resource packs.")).color((TextColor)NamedTextColor.GREEN);
        consoleSender.sendMessage(loadedMsg);
        if (player != null) {
            player.sendMessage(loadedMsg);
        }
    }

    private void addResourcePacks(@Nullable Player player, String rootName) {
        boolean verifyPacks = this.getConfig().getBoolean("verify-resource-packs");
        boolean groups = rootName.equals("groups");
        String typeName = groups ? "group" : "server";
        VelocityConfig root = groups ? this.getConfig().getConfig("groups") : this.getConfig().getConfig("servers");
        for (String string : root.getKeys()) {
            this.log("Checking %s - %s", typeName, string);
            VelocityConfig serverConfig = root.getConfig(string);
            HashMap<String, VelocityConfig> configs = new HashMap<String, VelocityConfig>();
            configs.put("default", serverConfig.getConfig("resourcepack"));
            VelocityConfig versionConfig = serverConfig.getConfig("version");
            if (versionConfig != null) {
                this.log("Detected versioned resource packs for %s", string);
                for (String string2 : versionConfig.getKeys()) {
                    configs.put(string2, versionConfig.getConfig(string2).getConfig("resourcepack"));
                    this.log("Added version config %s for %s", string2, string);
                }
            }
            configs.forEach((id, config) -> {
                if (config == null) {
                    this.log("Invalid resource pack config found for %s. You probably forgot to rename something!", id);
                    return;
                }
                this.registerResourcePack(serverConfig, (VelocityConfig)config, (String)id, name, typeName, groups, verifyPacks, player);
            });
        }
    }

    private void registerResourcePack(VelocityConfig rootServerConfig, VelocityConfig resourcePack, String id, String name, String typeName, boolean groups, boolean verifyPacks, @Nullable Player player) {
        boolean generateHash;
        List<String> hashes;
        List<String> urls = resourcePack.getStringList("urls");
        if (urls.isEmpty()) {
            urls = List.of(resourcePack.getString("url", ""));
        }
        if ((hashes = resourcePack.getStringList("hashes")).isEmpty()) {
            hashes = List.of(resourcePack.getString("hash", ""));
        }
        if (!(generateHash = resourcePack.getBoolean("generate-hash", false)) && urls.size() != hashes.size()) {
            this.getLogger().error("There are not the same amount of URLs and hashes! Please provide a hash for every resource pack URL! ({}, {})", (Object)id, (Object)name);
            this.getLogger().error("Hint: Enabling generate-hash will auto-generate missing hashes");
        }
        for (int i = 0; i < urls.size(); ++i) {
            String url = urls.get(i);
            String hash = i >= hashes.size() ? null : hashes.get(i);
            this.handleRegister(rootServerConfig, resourcePack, name, id, typeName, url, hash, groups, verifyPacks, player);
        }
    }

    private void handleRegister(VelocityConfig rootServerConfig, VelocityConfig resourcePack, String name, String id, String typeName, String url, @Nullable String hash, boolean groups, boolean verifyPacks, @Nullable Player player) {
        ConsoleCommandSource consoleSender = this.getServer().getConsoleCommandSource();
        if (((String)url).isEmpty()) {
            this.logger.error("No URL found for {}. Did you set up the config correctly?", (Object)name);
        }
        AtomicInteger sizeInMB = new AtomicInteger();
        url = this.checkLocalHostUrl((String)url);
        this.checkValidEnding((String)url);
        this.checkForRehost((String)url, name);
        ResourcePackURLData data = this.tryGenerateHash(resourcePack, (String)url, hash, sizeInMB);
        if (data != null) {
            hash = data.getUrlHash();
        }
        if (this.getConfig().getBoolean("enable-mc-164316-fix", false)) {
            url = (String)url + "#" + hash;
        }
        if (verifyPacks) {
            try {
                Consumer<Integer> consumer = size -> {
                    this.getLogger().info("Performing version size check for {} ({})...", (Object)name, (Object)id);
                    for (ClientVersion clientVersion : ClientVersion.values()) {
                        String sizeStr = clientVersion.getDisplay() + " (" + clientVersion.getMaxSizeMB() + " MB): ";
                        if (clientVersion.getMaxSizeMB() < size) {
                            this.logger.info("{}Unsupported.", (Object)sizeStr);
                            continue;
                        }
                        this.logger.info("{}Supported.", (Object)sizeStr);
                    }
                    sizeInMB.set((int)size);
                };
                if (data == null) {
                    data = HashingUtil.performPackCheck((String)url, hash);
                }
                consumer.accept(data.getSize());
                if (hash == null || !hash.equalsIgnoreCase(data.getUrlHash())) {
                    this.getLogger().error("-----------------------------------------------");
                    this.getLogger().error("Your hash does not match the URL file provided!");
                    this.getLogger().error("Target {}: {} ({})", new Object[]{typeName, name, id});
                    this.getLogger().error("The URL hash returned: {}", (Object)data.getUrlHash());
                    this.getLogger().error("Your config hash returned: {}", (Object)data.getConfigHash());
                    this.getLogger().error("Please provide a correct SHA-1 hash!");
                    this.getLogger().error("-----------------------------------------------");
                    return;
                }
                Component hashMsg = Component.text((String)("Hash verification complete for " + typeName + " " + name + " (" + id + ").")).color((TextColor)NamedTextColor.GREEN);
                consoleSender.sendMessage(hashMsg);
                if (player != null) {
                    player.sendMessage(hashMsg);
                }
            }
            catch (Exception e) {
                this.getLogger().error("Please provide a correct SHA-1 hash/url!", (Throwable)e);
            }
        }
        ResourcePackVersion version = null;
        try {
            double fixedVersion = Double.parseDouble(id);
            version = ResourcePackVersion.of(fixedVersion, fixedVersion);
        }
        catch (NumberFormatException ignored) {
            try {
                String[] ranged = id.split("-");
                double min = Double.parseDouble(ranged[0]);
                double max = Double.parseDouble(ranged[1]);
                version = ResourcePackVersion.of(min, max);
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        if (groups) {
            boolean exact = rootServerConfig.getBoolean("exact-match");
            for (String serverName : rootServerConfig.getStringList("servers")) {
                for (RegisteredServer registeredServer : this.server.getAllServers()) {
                    boolean matches;
                    String serverInfoName = registeredServer.getServerInfo().getName();
                    boolean bl = matches = exact ? serverInfoName.equals(serverName) : serverInfoName.contains(serverName);
                    if (!matches) continue;
                    VelocityResourcePack pack = new VelocityResourcePack(this, serverInfoName, (String)url, hash, sizeInMB.get(), name, version);
                    this.resourcePacks.add(pack);
                    this.log("Added resource pack for server %s (%s)", serverInfoName, pack.getUUID().toString());
                }
            }
        } else {
            this.resourcePacks.add(new VelocityResourcePack(this, name, (String)url, hash, sizeInMB.get(), null, version));
        }
    }

    private void checkUnload() {
        VelocityConfig unloadPack = this.getConfig().getConfig("unload-pack");
        boolean enableUnload = unloadPack.getBoolean("enable");
        if (enableUnload) {
            String url = unloadPack.getString("url", "");
            url = this.checkLocalHostUrl(url);
            this.checkValidEnding(url);
            this.checkForRehost(url, "unload-pack");
            String hash = unloadPack.getString("hash");
            ResourcePackURLData data = this.tryGenerateHash(unloadPack, url, hash, new AtomicInteger(0));
            if (data != null) {
                hash = data.getUrlHash();
            }
            VelocityResourcePack resourcePack = new VelocityResourcePack(this, EMPTY_SERVER_NAME, url, hash, 0, null, null);
            this.resourcePacks.add(resourcePack);
        }
    }

    private void checkGlobal() {
        VelocityConfig globalPack = this.getConfig().getConfig("global-pack");
        if (globalPack == null) {
            return;
        }
        boolean enableGlobal = globalPack.getBoolean("enable");
        if (!enableGlobal) {
            return;
        }
        HashMap<String, VelocityConfig> configs = new HashMap<String, VelocityConfig>();
        configs.put("default", globalPack);
        VelocityConfig versionConfig = globalPack.getConfig("version");
        if (versionConfig != null) {
            this.log("Detected versioned resource packs for global pack", new Object[0]);
            for (String string : versionConfig.getKeys()) {
                configs.put(string, versionConfig.getConfig(string));
                this.log("Added version config %s for global pack", string);
            }
        }
        configs.forEach((id, config) -> {
            boolean generateHash;
            List<String> hashes;
            List<String> urls = config.getStringList("urls");
            if (urls.isEmpty()) {
                urls = List.of(config.getString("url", ""));
            }
            if ((hashes = config.getStringList("hashes")).isEmpty()) {
                hashes = List.of(config.getString("hash", ""));
            }
            if (!(generateHash = config.getBoolean("generate-hash", false)) && urls.size() != hashes.size()) {
                this.getLogger().error("[global-pack] There are not the same amount of URLs and hashes! Please provide a hash for every resource pack URL! ({})", id);
                this.getLogger().error("Hint: Enabling generate-hash will auto-generate missing hashes");
            }
            for (int i = 0; i < urls.size(); ++i) {
                String url = urls.get(i);
                String hash = i >= hashes.size() ? null : hashes.get(i);
                this.registerGlobalResourcePack((VelocityConfig)config, (String)id, url, hash);
            }
        });
    }

    private void registerGlobalResourcePack(VelocityConfig globalPack, String id, String url, String hash) {
        url = this.checkLocalHostUrl((String)url);
        this.checkValidEnding((String)url);
        this.checkForRehost((String)url, "global-pack");
        ResourcePackURLData data = this.tryGenerateHash(globalPack, (String)url, hash, new AtomicInteger(0));
        if (data != null) {
            hash = data.getUrlHash();
        }
        if (this.getConfig().getBoolean("enable-mc-164316-fix", false)) {
            url = (String)url + "#" + hash;
        }
        ResourcePackVersion version = null;
        try {
            double fixedVersion = Double.parseDouble(id);
            version = ResourcePackVersion.of(fixedVersion, fixedVersion);
        }
        catch (NumberFormatException ignored) {
            try {
                String[] ranged = id.split("-");
                double min = Double.parseDouble(ranged[0]);
                double max = Double.parseDouble(ranged[1]);
                version = ResourcePackVersion.of(min, max);
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        VelocityResourcePack resourcePack = new VelocityResourcePack(this, "ForcePack-Global-Server-" + (String)url, (String)url, hash, 0, null, version);
        this.resourcePacks.add(resourcePack);
        this.globalResourcePacks.add(resourcePack);
    }

    private String checkLocalHostUrl(String url) {
        if (url.startsWith("forcepack://")) {
            File generatedFilePath = new File(String.valueOf(this.getDataDirectory()) + File.separator + url.replace("forcepack://", ""));
            this.log("Using local resource pack host for " + url + " (" + String.valueOf(generatedFilePath) + ")", new Object[0]);
            if (this.getWebServer().isEmpty()) {
                this.getLogger().error("Unable to locally host resource pack '{}' because the web server is not active!", (Object)url);
                return url;
            }
            this.webServer.addHostedPack(generatedFilePath);
            url = this.webServer.getHostedEndpoint(url);
        }
        return url;
    }

    private void checkValidEnding(String url) {
        if (!this.isValidEnding(url)) {
            this.getLogger().error("Your URL has an invalid or unknown format. URLs must have no redirects and use the .zip extension. If you are using Dropbox, change dl=0 to dl=1.");
            this.getLogger().error("ForcePack will still load in the event this check is incorrect. Please make an issue or pull request if this is so.");
        }
    }

    private void checkForRehost(String url, String section) {
        if (this.isDefaultHost(url)) {
            this.getLogger().warn("[{}] You are using a default resource pack provided by the plugin.  It's highly recommended you re-host this pack using the webserver or on a CDN such as https://mc-packs.net for faster load times. Leaving this as default potentially sends a lot of requests to my personal web server, which isn't ideal!", (Object)section);
            this.getLogger().warn("ForcePack will still load and function like normally.");
        }
        this.getBlacklistedSite(url).ifPresent(blacklistedSite -> this.getLogger().error("Invalid resource pack site used! '{}' cannot be used for hosting resource packs!", blacklistedSite));
    }

    private @Nullable ResourcePackURLData tryGenerateHash(VelocityConfig resourcePack, String url, String hash, AtomicInteger sizeInMB) {
        if (resourcePack.getBoolean("generate-hash", false)) {
            this.getLogger().info("Auto-generating resource pack hash.");
            this.getLogger().info("Downloading resource pack for hash generation...");
            try {
                ResourcePackURLData data = HashingUtil.performPackCheck(url, hash);
                this.getLogger().info("Size of resource pack: {} MB", (Object)data.getSize());
                sizeInMB.set(data.getSize());
                this.getLogger().info("Auto-generated resource pack hash: {}", (Object)data.getUrlHash());
                return data;
            }
            catch (Exception e) {
                this.getLogger().error("Unable to auto-generate resource pack hash, reverting to config setting", (Throwable)e);
            }
        }
        return null;
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Path getDataDirectory() {
        return this.dataDirectory;
    }

    public VelocityConfig getConfig() {
        return this.config;
    }

    @Override
    public Set<ResourcePack> getResourcePacks() {
        return Collections.unmodifiableSet(this.resourcePacks);
    }

    @Override
    public PlatformScheduler<?> getScheduler() {
        return this.scheduler;
    }

    @Override
    public boolean exemptNextResourcePackSend(UUID uuid) {
        return this.temporaryExemptedPlayers.add(uuid);
    }

    @Override
    public Set<ResourcePack> getPacksForVersion(int protocolVersion) {
        throw new IllegalStateException("Use getPacksByServerAndVersion for Velocity");
    }

    public Optional<Set<ResourcePack>> getPacksByServerAndVersion(String server, ProtocolVersion version) {
        int protocolVersion = version.getProtocol();
        double packFormat = PackFormatResolver.getPackFormat(protocolVersion);
        return this.searchForValidPacks(this.resourcePacks, server, version, packFormat).or(() -> this.searchForValidPacks(this.globalResourcePacks, GLOBAL_SERVER_NAME, version, packFormat));
    }

    private Optional<Set<ResourcePack>> searchForValidPacks(Set<ResourcePack> packs, String serverName, ProtocolVersion protocolVersion, double packVersion) {
        this.log("Searching for a resource pack with pack version %d", packVersion);
        Set<Object> validPacks = new HashSet(packs.size());
        boolean hasVersionOverride = false;
        for (ResourcePack resourcePack : packs.stream().filter(pack -> {
            boolean matches;
            boolean bl = matches = pack.getServer().equals(serverName) || serverName.equals(GLOBAL_SERVER_NAME) && pack.getServer().contains(GLOBAL_SERVER_NAME);
            if (!matches) {
                this.log("Filtering out %s: %s != %s", pack.getUUID().toString(), pack.getServer(), serverName);
            }
            return matches;
        }).collect(Collectors.toList())) {
            Optional<ResourcePackVersion> version = resourcePack.getVersion();
            this.log("Trying resource pack %s (%s)", resourcePack.getURL(), version.isEmpty() ? version.toString() : version.get().toString());
            boolean inVersion = version.isEmpty() || version.get().inVersion(packVersion);
            if (!inVersion) continue;
            if (version.isPresent()) {
                hasVersionOverride = true;
            }
            validPacks.add(resourcePack);
            this.log("Added resource pack %s", resourcePack.getURL());
            if (protocolVersion.getProtocol() >= 765) continue;
            break;
        }
        if (!validPacks.isEmpty()) {
            this.log("Found valid resource packs (%d)", validPacks.size());
            if (hasVersionOverride) {
                validPacks = validPacks.stream().filter(pack -> pack.getVersion().isPresent()).collect(Collectors.toSet());
            }
            this.log("Found valid resource packs (filtered to: %d)", validPacks.size());
            for (ResourcePack resourcePack : validPacks) {
                this.log("Chosen resource pack %s", resourcePack.getURL());
            }
            return Optional.of(validPacks);
        }
        this.log("No valid resource packs found", new Object[0]);
        return Optional.empty();
    }

    public PackHandler getPackHandler() {
        return this.packHandler;
    }

    public MiniMessage getMiniMessage() {
        if (this.miniMessage != null) {
            return this.miniMessage;
        }
        this.miniMessage = MiniMessage.miniMessage();
        return this.miniMessage;
    }

    @Override
    public void log(String info, Object ... format) {
        if (this.getConfig().getBoolean("debug")) {
            this.getLogger().info(String.format(info, format));
        }
    }
}

