/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload.repository;

import dev.vankka.dependencydownload.dependency.Dependency;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;

public interface Repository {
    public String getHost();

    default public URL createURL(Dependency dependency) throws MalformedURLException {
        return new URL(this.getHost() + '/' + dependency.getMavenPath());
    }

    default public URLConnection openConnection(Dependency dependency) throws IOException {
        URLConnection connection = this.createURL(dependency).openConnection();
        if (connection instanceof HttpURLConnection) {
            if (!(connection instanceof HttpsURLConnection)) {
                throw new RuntimeException("HTTP is not supported.");
            }
            connection.setRequestProperty("User-Agent", "DependencyDownload/1.3.1");
        }
        return connection;
    }

    default public int getBufferSize() {
        return 8192;
    }
}

