/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.paper.cloud.bukkit;

import forcepack.libs.geantyref.TypeToken;
import forcepack.libs.paper.cloud.CommandManager;
import forcepack.libs.paper.cloud.bukkit.BukkitParserParameters;
import forcepack.libs.paper.cloud.bukkit.CloudBukkitCapabilities;
import forcepack.libs.paper.cloud.bukkit.annotation.specifier.AllowEmptySelection;
import forcepack.libs.paper.cloud.bukkit.annotation.specifier.DefaultNamespace;
import forcepack.libs.paper.cloud.bukkit.annotation.specifier.RequireExplicitNamespace;
import forcepack.libs.paper.cloud.bukkit.data.MultipleEntitySelector;
import forcepack.libs.paper.cloud.bukkit.data.MultiplePlayerSelector;
import forcepack.libs.paper.cloud.bukkit.internal.CraftBukkitReflection;
import forcepack.libs.paper.cloud.bukkit.parser.BlockPredicateParser;
import forcepack.libs.paper.cloud.bukkit.parser.EnchantmentParser;
import forcepack.libs.paper.cloud.bukkit.parser.ItemStackParser;
import forcepack.libs.paper.cloud.bukkit.parser.ItemStackPredicateParser;
import forcepack.libs.paper.cloud.bukkit.parser.MaterialParser;
import forcepack.libs.paper.cloud.bukkit.parser.NamespacedKeyParser;
import forcepack.libs.paper.cloud.bukkit.parser.OfflinePlayerParser;
import forcepack.libs.paper.cloud.bukkit.parser.PlayerParser;
import forcepack.libs.paper.cloud.bukkit.parser.WorldParser;
import forcepack.libs.paper.cloud.bukkit.parser.location.Location2DParser;
import forcepack.libs.paper.cloud.bukkit.parser.location.LocationParser;
import forcepack.libs.paper.cloud.bukkit.parser.selector.MultipleEntitySelectorParser;
import forcepack.libs.paper.cloud.bukkit.parser.selector.MultiplePlayerSelectorParser;
import forcepack.libs.paper.cloud.bukkit.parser.selector.SingleEntitySelectorParser;
import forcepack.libs.paper.cloud.bukkit.parser.selector.SinglePlayerSelectorParser;
import forcepack.libs.paper.cloud.parser.ParserParameters;
import java.lang.reflect.Method;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL)
public final class BukkitParsers {
    private BukkitParsers() {
    }

    public static <C> void register(CommandManager<C> manager) {
        manager.parserRegistry().registerParser(WorldParser.worldParser()).registerParser(MaterialParser.materialParser()).registerParser(PlayerParser.playerParser()).registerParser(OfflinePlayerParser.offlinePlayerParser()).registerParser(EnchantmentParser.enchantmentParser()).registerParser(LocationParser.locationParser()).registerParser(Location2DParser.location2DParser()).registerParser(ItemStackParser.itemStackParser()).registerParser(SingleEntitySelectorParser.singleEntitySelectorParser()).registerParser(SinglePlayerSelectorParser.singlePlayerSelectorParser());
        manager.parserRegistry().registerAnnotationMapper(AllowEmptySelection.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, annotation.value()));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultipleEntitySelector.class), parserParameters -> new MultipleEntitySelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultiplePlayerSelector.class), parserParameters -> new MultiplePlayerSelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        if (CraftBukkitReflection.classExists("org.bukkit.NamespacedKey")) {
            BukkitParsers.registerParserSupplierFor(manager, NamespacedKeyParser.class);
            manager.parserRegistry().registerAnnotationMapper(RequireExplicitNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.REQUIRE_EXPLICIT_NAMESPACE, true));
            manager.parserRegistry().registerAnnotationMapper(DefaultNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.DEFAULT_NAMESPACE, annotation.value()));
        }
        if (manager.hasCapability(CloudBukkitCapabilities.BRIGADIER)) {
            BukkitParsers.registerParserSupplierFor(manager, ItemStackPredicateParser.class);
            BukkitParsers.registerParserSupplierFor(manager, BlockPredicateParser.class);
        }
    }

    private static void registerParserSupplierFor(CommandManager<?> manager, @NonNull Class<?> argumentClass) {
        try {
            Method registerParserSuppliers = argumentClass.getDeclaredMethod("registerParserSupplier", CommandManager.class);
            registerParserSuppliers.setAccessible(true);
            registerParserSuppliers.invoke(null, manager);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

