/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.paper.cloud.bukkit.parser;

import forcepack.libs.paper.cloud.bukkit.BukkitCaptionKeys;
import forcepack.libs.paper.cloud.caption.CaptionVariable;
import forcepack.libs.paper.cloud.component.CommandComponent;
import forcepack.libs.paper.cloud.context.CommandContext;
import forcepack.libs.paper.cloud.context.CommandInput;
import forcepack.libs.paper.cloud.exception.parsing.ParserException;
import forcepack.libs.paper.cloud.parser.ArgumentParseResult;
import forcepack.libs.paper.cloud.parser.ArgumentParser;
import forcepack.libs.paper.cloud.parser.ParserDescriptor;
import forcepack.libs.paper.cloud.suggestion.BlockingSuggestionProvider;
import forcepack.libs.paper.cloud.suggestion.Suggestion;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.bukkit.Material;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class MaterialParser<C>
implements ArgumentParser<C, Material>,
BlockingSuggestionProvider<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, Material> materialParser() {
        return ParserDescriptor.of(new MaterialParser<C>(), Material.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, Material> materialComponent() {
        return CommandComponent.builder().parser(MaterialParser.materialParser());
    }

    @Override
    public @NonNull ArgumentParseResult<Material> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        try {
            Material material = Material.valueOf((String)input.toUpperCase(Locale.ROOT));
            return ArgumentParseResult.success(material);
        }
        catch (IllegalArgumentException exception) {
            return ArgumentParseResult.failure(new MaterialParseException(input, commandContext));
        }
    }

    @Override
    public @NonNull Iterable<@NonNull Suggestion> suggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return Arrays.stream(Material.values()).map(Enum::name).map(String::toLowerCase).map(Suggestion::suggestion).collect(Collectors.toList());
    }

    public static final class MaterialParseException
    extends ParserException {
        private final String input;

        public MaterialParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(MaterialParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_MATERIAL, CaptionVariable.of("input", input));
            this.input = input;
        }

        public @NonNull String input() {
            return this.input;
        }
    }
}

