/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.velocity.cloud.suggestion;

import forcepack.libs.velocity.cloud.context.CommandContext;
import forcepack.libs.velocity.cloud.suggestion.MappingSuggestionFactory;
import forcepack.libs.velocity.cloud.suggestion.Suggestion;
import forcepack.libs.velocity.cloud.suggestion.SuggestionMapper;
import forcepack.libs.velocity.cloud.suggestion.Suggestions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public interface SuggestionFactory<C, S extends Suggestion> {
    public @NonNull CompletableFuture<@NonNull Suggestions<C, S>> suggest(@NonNull CommandContext<C> var1, @NonNull String var2);

    public @NonNull CompletableFuture<@NonNull Suggestions<C, S>> suggest(@NonNull C var1, @NonNull String var2);

    default public @NonNull Suggestions<C, S> suggestImmediately(@NonNull C sender, @NonNull String input) {
        try {
            return this.suggest(sender, input).join();
        }
        catch (CompletionException completionException) {
            Throwable cause = completionException.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw completionException;
        }
    }

    default public <S2 extends Suggestion> @NonNull SuggestionFactory<C, S2> mapped(@NonNull SuggestionMapper<S2> mapper) {
        return new MappingSuggestionFactory(this, mapper);
    }
}

