/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.paper.command;

import com.convallyria.forcepack.api.resourcepack.ResourcePack;
import com.convallyria.forcepack.api.utils.GeyserUtil;
import com.convallyria.forcepack.paper.ForcePackPaper;
import com.convallyria.forcepack.paper.event.ForcePackReloadEvent;
import com.convallyria.forcepack.paper.translation.Translations;
import com.convallyria.forcepack.paper.util.ProtocolUtil;
import forcepack.libs.paper.cloud.annotations.Argument;
import forcepack.libs.paper.cloud.annotations.Command;
import forcepack.libs.paper.cloud.annotations.CommandDescription;
import forcepack.libs.paper.cloud.annotations.Default;
import forcepack.libs.paper.cloud.annotations.Permission;
import forcepack.libs.pe.api.PacketEvents;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerResourcePackRemove;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ForcePackCommand {
    private final ForcePackPaper plugin;

    public ForcePackCommand(ForcePackPaper plugin) {
        this.plugin = plugin;
    }

    @CommandDescription(value="Default ForcePack command")
    @Command(value="forcepack")
    public void onDefault(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "ForcePack by SamB440. Type /forcepack help for help.");
    }

    @CommandDescription(value="Reloads the plugin config along with the resource pack")
    @Permission(value={"forcepack.reload"})
    @Command(value="forcepack reload [send]")
    public void onReload(CommandSender sender, @Argument(value="send", description="Whether to send the updated resource pack to players") @Default(value="true") boolean send) {
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Reloading...");
        this.plugin.reloadConfig();
        this.plugin.reload();
        PacketEvents.getAPI().getSettings().debug(this.plugin.debug());
        Bukkit.getPluginManager().callEvent((Event)new ForcePackReloadEvent());
        if (!this.plugin.velocityMode && send) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (this.plugin.isWaiting(player)) continue;
                boolean geyser = this.plugin.getConfig().getBoolean("Server.geyser") && GeyserUtil.isBedrockPlayer(player.getUniqueId());
                boolean canBypass = player.hasPermission("forcepack.bypass") && this.plugin.getConfig().getBoolean("Server.bypass-permission");
                this.plugin.log(player.getName() + "'s exemptions: geyser, " + geyser + ". permission, " + canBypass + ".", new Object[0]);
                if (geyser || canBypass) continue;
                Translations.RELOADING.send(player, new Object[0]);
                Set<ResourcePack> resourcePacks = this.plugin.getPacksForVersion(player);
                this.plugin.addToWaiting(player.getUniqueId(), resourcePacks);
                if (ProtocolUtil.getProtocolVersion(player) >= 765) {
                    ProtocolUtil.sendPacketBypassingVia(player, new WrapperPlayServerResourcePackRemove((UUID)null));
                }
                resourcePacks.forEach(pack -> pack.setResourcePack(player.getUniqueId()));
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Done!");
    }
}

