/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.paper.libs.languagy.api;

import com.convallyria.forcepack.paper.libs.languagy.api.language.Language;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class HookedPlugin {
    private final Plugin plugin;
    private final File folder;
    private final File fallback;
    private final Map<Language, FileConfiguration> cachedLanguages = new ConcurrentHashMap<Language, FileConfiguration>();
    private boolean debug;

    public HookedPlugin(Plugin plugin, File folder, File fallback) {
        this.plugin = plugin;
        this.folder = folder;
        this.fallback = fallback;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public File getFolder() {
        return this.folder;
    }

    public File getFallback() {
        return this.fallback;
    }

    public Map<Language, FileConfiguration> getCachedLanguages() {
        return Collections.unmodifiableMap(this.cachedLanguages);
    }

    public void addCachedLanguage(Language language, FileConfiguration config) {
        this.cachedLanguages.put(language, config);
    }

    public void removeCachedLanguage(Language language) {
        this.cachedLanguages.remove((Object)language);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

