/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.paper.libs.languagy.api.language;

import com.convallyria.forcepack.paper.libs.languagy.api.HookedPlugin;
import com.convallyria.forcepack.paper.libs.languagy.api.adventure.AdventurePlatform;
import com.convallyria.forcepack.paper.libs.languagy.api.event.AsyncPlayerTranslateEvent;
import com.convallyria.forcepack.paper.libs.languagy.api.language.Language;
import com.convallyria.forcepack.paper.libs.languagy.api.language.TranslationKeys;
import com.convallyria.forcepack.paper.libs.languagy.api.language.key.LanguageKey;
import com.convallyria.forcepack.paper.libs.languagy.api.language.key.TranslationKey;
import com.convallyria.forcepack.paper.libs.languagy.api.language.translation.Translation;
import com.convallyria.forcepack.paper.libs.languagy.api.service.LanguageWatchService;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Translator {
    public static boolean RUNNING_FOLIA = true;
    private Method LEGACY_LOCALE_METHOD;
    private final Plugin plugin;
    @Nullable
    private final AdventurePlatform adventure;
    private final Language defaultLanguage;
    private File fallback;
    private boolean debug;
    private HookedPlugin hook;
    private LanguageWatchService watchService;

    private Translator(@NotNull Plugin plugin, @NotNull String folderName, @NotNull Language defaultLanguage, boolean debug, @Nullable AdventurePlatform adventure) {
        if (this.getVersionNumber() < 15) {
            try {
                this.LEGACY_LOCALE_METHOD = Player.Spigot.class.getMethod("getLocale", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                plugin.getLogger().log(Level.SEVERE, "Tried to initialise legacy support but failed.", e);
            }
        }
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServerInitEvent");
        }
        catch (ReflectiveOperationException e) {
            RUNNING_FOLIA = false;
        }
        this.plugin = plugin;
        this.adventure = adventure;
        this.defaultLanguage = defaultLanguage;
        this.debug = debug;
        File fallback = new File(plugin.getDataFolder() + File.separator + folderName + File.separator + defaultLanguage.getKey().getCode() + ".yml");
        this.setup(plugin, fallback);
        try {
            this.debug("[Languagy] Setting up file watch service...");
            this.watchService = new LanguageWatchService(this.hook);
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.SEVERE, "[Languagy] Error whilst setting up file watch service", e);
        }
    }

    public void close() {
        this.watchService.shutdown();
    }

    @Deprecated
    public static Translator of(@NotNull Plugin plugin) {
        return Translator.of(plugin, Language.BRITISH_ENGLISH);
    }

    public static Translator of(@NotNull Plugin plugin, @Nullable AdventurePlatform adventure) {
        return Translator.of(plugin, Language.BRITISH_ENGLISH, adventure);
    }

    @Deprecated
    public static Translator of(@NotNull Plugin plugin, @NotNull Language defaultLanguage) {
        return Translator.of(plugin, "lang", defaultLanguage);
    }

    public static Translator of(@NotNull Plugin plugin, @NotNull Language defaultLanguage, @Nullable AdventurePlatform adventure) {
        return Translator.of(plugin, "lang", defaultLanguage, adventure);
    }

    @Deprecated
    public static Translator of(@NotNull Plugin plugin, @NotNull String folderName, @NotNull Language defaultLanguage) {
        return Translator.of(plugin, folderName, defaultLanguage, false);
    }

    public static Translator of(@NotNull Plugin plugin, @NotNull String folderName, @NotNull Language defaultLanguage, @Nullable AdventurePlatform adventure) {
        return Translator.of(plugin, folderName, defaultLanguage, false, adventure);
    }

    @Deprecated
    public static Translator of(@NotNull Plugin plugin, @NotNull String folderName, @NotNull Language defaultLanguage, boolean debug) {
        return Translator.of(plugin, folderName, defaultLanguage, debug, null);
    }

    public static Translator of(@NotNull Plugin plugin, @NotNull String folderName, @NotNull Language defaultLanguage, boolean debug, @Nullable AdventurePlatform adventure) {
        return new Translator(plugin, folderName, defaultLanguage, debug, adventure);
    }

    public Translator setFallback(File fallback) {
        this.fallback = fallback;
        return this;
    }

    @NotNull
    public HookedPlugin getHook() {
        return this.hook;
    }

    public Translation getTranslationFor(@NotNull Player target, @NotNull TranslationKey key) {
        FileConfiguration config;
        String lang = this.fallback.getAbsoluteFile().getParentFile().toString();
        Language targetLanguage = this.getLanguage(target);
        File file = new File(lang + File.separator + targetLanguage.getKey().getCode() + ".yml");
        FileConfiguration fileConfiguration = config = file.exists() ? this.hook.getCachedLanguages().get((Object)targetLanguage) : this.hook.getCachedLanguages().get((Object)this.defaultLanguage);
        if (config.get(key.getKey()) == null) {
            if (this.hook.isDebug()) {
                String text = "[Languagy] Translation was requested, but path did not exist in '%s'! Try regenerating language files?";
                this.plugin.getLogger().warning(String.format(text, new Object[]{file.exists() ? targetLanguage : this.defaultLanguage}));
            }
            return Translation.of(target, targetLanguage, TranslationKeys.NOT_FOUND.getKey(), this.adventure);
        }
        Translation translation = config.isList(key.getKey()) ? Translation.of(target, targetLanguage, config.getStringList(key.getKey()), this.adventure) : Translation.of(target, targetLanguage, config.getString(key.getKey()), this.adventure);
        if (!RUNNING_FOLIA) {
            Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new AsyncPlayerTranslateEvent(target, translation, this.hook)));
        } else {
            Bukkit.getPluginManager().callEvent((Event)new AsyncPlayerTranslateEvent(target, translation, this.hook));
        }
        return translation;
    }

    public Language getLanguage(Player player) {
        return Language.getFromKey(LanguageKey.of(this.getLocale(player))).orElse(this.defaultLanguage);
    }

    @Nullable
    public FileConfiguration getFileConfiguration(@NotNull Player target) {
        Optional<Language> key = Language.getFromKey(LanguageKey.of(this.getLocale(target)));
        return key.map(language -> this.hook.getCachedLanguages().get(language)).orElse(this.hook.getCachedLanguages().get((Object)this.defaultLanguage));
    }

    private void setup(Plugin plugin, File fallback) {
        if (!fallback.exists()) {
            plugin.getLogger().warning("[Languagy] Could not initiate new translator: Fallback does not exist!");
            return;
        }
        this.fallback = fallback;
        File folder = fallback.getAbsoluteFile().getParentFile();
        this.hook = new HookedPlugin(plugin, folder, fallback);
        if (this.hook.isDebug()) {
            plugin.getLogger().info(folder.toString());
        }
        for (Language language : Language.values()) {
            File file = new File(folder.toString() + File.separator + language.getKey().getCode() + ".yml");
            if (!file.exists() || !file.getName().contains(language.getKey().getCode())) {
                String reason;
                String string = reason = !file.exists() ? "Does not exist" : "File name is incorrect";
                if (!this.hook.isDebug()) continue;
                plugin.getLogger().warning("[Languagy] Language file could not be loaded: " + file.getName() + ". Reason: " + reason);
                continue;
            }
            this.hook.addCachedLanguage(language, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
            this.debug("[Languagy] Loaded language '" + language.getKey().getCode() + "'.");
        }
    }

    @NotNull
    public File getFallback() {
        return this.fallback;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Translator debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    private void debug(String info) {
        if (this.isDebug()) {
            this.plugin.getLogger().info("[Languagy] " + info);
        }
    }

    private String getLocale(Player player) {
        try {
            return player.getLocale();
        }
        catch (NoSuchMethodError e) {
            try {
                return (String)this.LEGACY_LOCALE_METHOD.invoke((Object)player.spigot(), new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "[Languagy] Failed to invoke legacy support", ex);
                return "en_us";
            }
        }
    }

    private int getVersionNumber() {
        String[] split = Bukkit.getBukkitVersion().split("-")[0].split("\\.");
        return Integer.parseInt(split[1]);
    }
}

