/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.paper.libs.languagy.api.service;

import com.convallyria.forcepack.paper.libs.languagy.api.HookedPlugin;
import com.convallyria.forcepack.paper.libs.languagy.api.language.Language;
import com.convallyria.forcepack.paper.libs.languagy.api.language.key.LanguageKey;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageWatchService {
    private final ScheduledExecutorService executorService;
    private final WatchService watchService = FileSystems.getDefault().newWatchService();

    public LanguageWatchService(HookedPlugin hookedPlugin) throws IOException {
        Path path = hookedPlugin.getFolder().toPath();
        path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        this.executorService = Executors.newScheduledThreadPool(1);
        final Runnable actualTask = () -> {
            try {
                WatchKey key = this.watchService.take();
                for (WatchEvent<?> event : key.pollEvents()) {
                    String context = String.valueOf(event.context());
                    Optional<Language> language = Language.getFromKey(LanguageKey.of(context.replace(".yml", "")));
                    if (!language.isPresent()) continue;
                    if (event.kind().equals(StandardWatchEventKinds.ENTRY_DELETE)) {
                        if (hookedPlugin.getFallback().getName().equals(context)) continue;
                        hookedPlugin.removeCachedLanguage(language.get());
                        continue;
                    }
                    File targetFile = new File(hookedPlugin.getFolder() + File.separator + context);
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)targetFile);
                    hookedPlugin.addCachedLanguage(language.get(), (FileConfiguration)config);
                }
                if (!key.reset()) {
                    this.executorService.shutdown();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        };
        this.executorService.scheduleAtFixedRate(new Runnable(){
            private final ExecutorService executor = Executors.newSingleThreadExecutor();
            private Future<?> lastExecution;

            @Override
            public void run() {
                if (this.lastExecution != null && !this.lastExecution.isDone()) {
                    return;
                }
                this.lastExecution = this.executor.submit(actualTask);
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.executorService.shutdown();
        try {
            this.watchService.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

