/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.velocity.command;

import com.convallyria.forcepack.velocity.ForcePackVelocity;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import forcepack.libs.velocity.cloud.annotations.Argument;
import forcepack.libs.velocity.cloud.annotations.Command;
import forcepack.libs.velocity.cloud.annotations.CommandDescription;
import forcepack.libs.velocity.cloud.annotations.Default;
import forcepack.libs.velocity.cloud.annotations.Permission;
import java.util.UUID;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class ForcePackCommand {
    private final ForcePackVelocity plugin;

    public ForcePackCommand(ForcePackVelocity plugin) {
        this.plugin = plugin;
    }

    @CommandDescription(value="Default ForcePack command")
    @Command(value="vforcepack|velocityforcepack")
    public void onDefault(CommandSource sender) {
        sender.sendMessage((Component)Component.text((String)"ForcePack by SamB440. Type /vforcepack help for help.", (TextColor)NamedTextColor.GREEN));
    }

    @CommandDescription(value="Reloads the plugin config along with the resource pack")
    @Permission(value={"forcepack.reload"})
    @Command(value="vforcepack|velocityforcepack reload [send]")
    public void onReload(CommandSource commandSource, @Argument(value="send", description="Whether to send the updated resource pack to players") @Default(value="true") boolean send) {
        ConsoleCommandSource source = this.plugin.getServer().getConsoleCommandSource();
        UUID possibleUUID = (UUID)commandSource.pointers().getOrDefault(Identity.UUID, null);
        Player sender = possibleUUID == null ? null : (Player)this.plugin.getServer().getPlayer(possibleUUID).orElse(null);
        Component reloadMsg = Component.text((String)"Reloading...").color((TextColor)NamedTextColor.GREEN);
        source.sendMessage(reloadMsg);
        if (sender != null) {
            sender.sendMessage(reloadMsg);
        }
        this.plugin.reloadConfig();
        this.plugin.loadResourcePacks(sender);
        if (send) {
            for (Player player : this.plugin.getServer().getAllPlayers()) {
                player.getCurrentServer().ifPresent(serverConnection -> this.plugin.getPackHandler().setPack(player, (ServerConnection)serverConnection));
            }
        }
        Component doneMsg = Component.text((String)"Done!").color((TextColor)NamedTextColor.GREEN);
        source.sendMessage(doneMsg);
        if (sender != null) {
            sender.sendMessage(doneMsg);
        }
    }
}

