/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.velocity.config;

import com.convallyria.forcepack.velocity.ForcePackVelocity;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VelocityConfig {
    private final CommentedConfig config;
    private final File file;

    public VelocityConfig(ForcePackVelocity plugin) {
        File file = new File(String.valueOf(plugin.getDataDirectory()) + File.separator + "config.toml");
        CommentedFileConfig conf = CommentedFileConfig.of((File)file, (ConfigFormat)TomlFormat.instance());
        conf.load();
        conf.close();
        this.config = conf;
        this.file = file;
    }

    public VelocityConfig(CommentedConfig config, File file) {
        this.config = config;
        this.file = file;
    }

    public @Nullable Object get(String path) {
        Object obj = this.config.get(path);
        if (obj instanceof CommentedConfig) {
            return this.getConfig(path);
        }
        return obj;
    }

    public CommentedConfig getConfig() {
        return this.config;
    }

    public VelocityConfig getConfig(String path) {
        return this.config.get(path) == null ? null : new VelocityConfig((CommentedConfig)this.config.get(path), this.file);
    }

    public List<String> getStringList(String path) {
        return (List)this.config.getOrElse(path, new ArrayList());
    }

    public Map<String, Object> getMap(String path) {
        CommentedConfig section = (CommentedConfig)this.config.get(path);
        if (section == null) {
            return new HashMap<String, Object>();
        }
        return section.valueMap();
    }

    public void setUnsafe(String path, Object value) {
        this.config.set(path, value);
    }

    public void remove(String path) {
        this.config.remove(path);
    }

    public @Nullable String getString(String path) {
        return (String)this.config.get(path);
    }

    public String getString(String path, String def) {
        return (String)this.config.getOrElse(path, (Object)def);
    }

    public boolean getBoolean(String path) {
        return (Boolean)this.config.get(path);
    }

    public boolean getBoolean(String path, boolean def) {
        return (Boolean)this.config.getOrElse(path, (Object)def);
    }

    public int getInt(String path) {
        return this.config.getIntOrElse(path, -1);
    }

    public int getInt(String path, int def) {
        return this.config.getIntOrElse(path, def);
    }

    public long getLong(String path) {
        return this.config.getLong(path);
    }

    public long getLong(String path, long def) {
        return this.config.getLongOrElse(path, def);
    }

    public Collection<? extends String> getKeys() {
        return new HashSet(this.config.valueMap().keySet());
    }
}

