/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.paper.cloud;

import forcepack.libs.paper.cloud.Command;
import forcepack.libs.paper.cloud.description.Description;
import forcepack.libs.paper.cloud.meta.CommandMeta;
import java.util.Collection;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public interface CommandBuilderSource<C> {
    default public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull Collection<String> aliases, @NonNull Description description, @NonNull CommandMeta meta) {
        return this.decorateBuilder(Command.newBuilder(name, meta, description, aliases.toArray(new String[0])));
    }

    default public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull Collection<String> aliases, @NonNull CommandMeta meta) {
        return this.decorateBuilder(Command.newBuilder(name, meta, Description.empty(), aliases.toArray(new String[0])));
    }

    default public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull CommandMeta meta, @NonNull Description description, String ... aliases) {
        return this.decorateBuilder(Command.newBuilder(name, meta, description, aliases));
    }

    default public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull CommandMeta meta, String ... aliases) {
        return this.decorateBuilder(Command.newBuilder(name, meta, Description.empty(), aliases));
    }

    default public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull Description description, String ... aliases) {
        return this.decorateBuilder(Command.newBuilder(name, this.createDefaultCommandMeta(), description, aliases));
    }

    default public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, String ... aliases) {
        return this.decorateBuilder(Command.newBuilder(name, this.createDefaultCommandMeta(), Description.empty(), aliases));
    }

    public @NonNull CommandMeta createDefaultCommandMeta();

    @API(status=API.Status.INTERNAL)
    public @NonNull Command.Builder<C> decorateBuilder(@NonNull Command.Builder<C> var1);
}

