/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api;

import forcepack.libs.pe.api.event.EventManager;
import forcepack.libs.pe.api.injector.ChannelInjector;
import forcepack.libs.pe.api.manager.player.PlayerManager;
import forcepack.libs.pe.api.manager.protocol.ProtocolManager;
import forcepack.libs.pe.api.manager.registry.ItemRegistry;
import forcepack.libs.pe.api.manager.registry.RegistryManager;
import forcepack.libs.pe.api.manager.server.ServerManager;
import forcepack.libs.pe.api.netty.NettyManager;
import forcepack.libs.pe.api.protocol.item.type.ItemType;
import forcepack.libs.pe.api.settings.PacketEventsSettings;
import forcepack.libs.pe.api.util.LogManager;
import forcepack.libs.pe.api.util.PEVersion;
import forcepack.libs.pe.api.util.PEVersions;
import forcepack.libs.pe.api.util.updatechecker.UpdateChecker;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class PacketEventsAPI<T> {
    private final EventManager eventManager = new EventManager();
    private final PacketEventsSettings settings = new PacketEventsSettings();
    private final UpdateChecker updateChecker = new UpdateChecker();
    private final LogManager logManager = new LogManager();
    private static final Logger LOGGER = Logger.getLogger(PacketEventsAPI.class.getName());

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public PacketEventsSettings getSettings() {
        return this.settings;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public PEVersion getVersion() {
        return PEVersions.CURRENT;
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public abstract void load();

    public abstract boolean isLoaded();

    public abstract void init();

    public abstract boolean isInitialized();

    public abstract void terminate();

    public abstract boolean isTerminated();

    public abstract T getPlugin();

    public abstract ServerManager getServerManager();

    public abstract ProtocolManager getProtocolManager();

    public abstract PlayerManager getPlayerManager();

    public abstract NettyManager getNettyManager();

    public abstract ChannelInjector getInjector();

    public RegistryManager getRegistryManager() {
        return new RegistryManager(){

            @Override
            public ItemRegistry getItemRegistry() {
                return new ItemRegistry(){

                    @Override
                    @Nullable
                    public ItemType getByName(String name) {
                        return null;
                    }

                    @Override
                    @Nullable
                    public ItemType getById(int id) {
                        return null;
                    }
                };
            }
        };
    }
}

