/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.item.enchantment.type;

import com.convallyria.forcepack.paper.libs.adventure.adventure.text.Component;
import forcepack.libs.pe.api.protocol.component.EnchantEffectComponentTypes;
import forcepack.libs.pe.api.protocol.component.IComponentMap;
import forcepack.libs.pe.api.protocol.component.StaticComponentMap;
import forcepack.libs.pe.api.protocol.item.enchantment.EnchantmentDefinition;
import forcepack.libs.pe.api.protocol.item.enchantment.type.StaticEnchantmentType;
import forcepack.libs.pe.api.protocol.mapper.CopyableEntity;
import forcepack.libs.pe.api.protocol.mapper.DeepComparableEntity;
import forcepack.libs.pe.api.protocol.mapper.MappedEntity;
import forcepack.libs.pe.api.protocol.mapper.MappedEntityRefSet;
import forcepack.libs.pe.api.protocol.mapper.MappedEntitySet;
import forcepack.libs.pe.api.protocol.nbt.NBT;
import forcepack.libs.pe.api.protocol.nbt.NBTCompound;
import forcepack.libs.pe.api.protocol.player.ClientVersion;
import forcepack.libs.pe.api.util.mappings.TypesBuilderData;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface EnchantmentType
extends MappedEntity,
CopyableEntity<EnchantmentType>,
DeepComparableEntity {
    public Component getDescription();

    public EnchantmentDefinition getDefinition();

    public MappedEntitySet<EnchantmentType> getExclusiveSet();

    public MappedEntityRefSet<EnchantmentType> getExclusiveRefSet();

    public StaticComponentMap getEffects();

    @Deprecated
    public static EnchantmentType decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        return EnchantmentType.decode(nbt, PacketWrapper.createDummyWrapper(version), data);
    }

    public static EnchantmentType decode(NBT nbt, PacketWrapper<?> wrapper, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        Component description = compound.getOrThrow("description", wrapper.getSerializers(), wrapper);
        EnchantmentDefinition definition = EnchantmentDefinition.decode((NBT)compound, wrapper);
        MappedEntityRefSet exclusiveSet = Optional.ofNullable(compound.getTagOrNull("exclusive_set")).map(tag -> MappedEntitySet.decodeRefSet(tag, wrapper)).orElseGet(MappedEntitySet::createEmpty);
        StaticComponentMap effects = Optional.ofNullable(compound.getTagOrNull("effects")).map(tag -> IComponentMap.decode(tag, wrapper, EnchantEffectComponentTypes.getRegistry())).orElse(StaticComponentMap.EMPTY);
        return new StaticEnchantmentType(data, description, definition, exclusiveSet, effects);
    }

    @Deprecated
    public static NBT encode(EnchantmentType type, ClientVersion version) {
        return EnchantmentType.encode(type, PacketWrapper.createDummyWrapper(version));
    }

    public static NBT encode(EnchantmentType type, PacketWrapper<?> wrapper) {
        NBTCompound compound = new NBTCompound();
        EnchantmentDefinition.encode(compound, wrapper, type.getDefinition());
        compound.set("description", type.getDescription(), wrapper.getSerializers(), wrapper);
        if (!type.getExclusiveRefSet().isEmpty()) {
            compound.set("exclusive_set", type.getExclusiveRefSet(), MappedEntitySet::encodeRefSet, wrapper);
        }
        if (!type.getEffects().isEmpty()) {
            compound.set("effects", type.getEffects(), IComponentMap::encode, wrapper);
        }
        return compound;
    }
}

