/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.particle;

import forcepack.libs.pe.api.protocol.nbt.NBT;
import forcepack.libs.pe.api.protocol.nbt.NBTCompound;
import forcepack.libs.pe.api.protocol.nbt.NBTNumber;
import forcepack.libs.pe.api.protocol.nbt.NBTString;
import forcepack.libs.pe.api.protocol.particle.data.ParticleData;
import forcepack.libs.pe.api.protocol.particle.type.ParticleType;
import forcepack.libs.pe.api.protocol.particle.type.ParticleTypes;
import forcepack.libs.pe.api.protocol.player.ClientVersion;
import forcepack.libs.pe.api.wrapper.PacketWrapper;

public class Particle<T extends ParticleData> {
    private ParticleType<T> type;
    private T data;

    public Particle(ParticleType<T> type, T data) {
        this.type = type;
        this.data = data;
    }

    public Particle(ParticleType<T> type) {
        this(type, ParticleData.emptyData());
    }

    public static Particle<?> read(PacketWrapper<?> wrapper) {
        ParticleType type = wrapper.readMappedEntity(ParticleTypes::getById);
        return new Particle(type, type.readData(wrapper));
    }

    public static <T extends ParticleData> void write(PacketWrapper<?> wrapper, Particle<T> particle) {
        wrapper.writeMappedEntity(particle.type);
        particle.getType().writeData(wrapper, particle.data);
    }

    public static Particle<?> decode(NBT nbt, ClientVersion version) {
        NBTCompound compound = (NBTCompound)nbt;
        NBT typeTag = compound.getTagOrThrow("type");
        ParticleType<?> type = typeTag instanceof NBTNumber ? ParticleTypes.getById(version, ((NBTNumber)typeTag).getAsInt()) : ParticleTypes.getByName(((NBTString)typeTag).getValue());
        Object data = type.decodeData(compound, version);
        return new Particle(type, data);
    }

    public static <T extends ParticleData> NBT encode(Particle<T> particle, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("type", new NBTString(particle.type.getName().toString()));
        particle.type.encodeData(particle.getData(), version, compound);
        return compound;
    }

    public ParticleType<T> getType() {
        return this.type;
    }

    public void setType(ParticleType<T> type) {
        this.type = type;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "Particle[" + this.type.getName() + ", " + this.data + ']';
    }
}

