/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.particle.data;

import forcepack.libs.pe.api.manager.server.ServerVersion;
import forcepack.libs.pe.api.protocol.color.Color;
import forcepack.libs.pe.api.protocol.nbt.NBTCompound;
import forcepack.libs.pe.api.protocol.nbt.NBTFloat;
import forcepack.libs.pe.api.protocol.particle.data.ParticleData;
import forcepack.libs.pe.api.protocol.player.ClientVersion;
import forcepack.libs.pe.api.util.Vector3f;
import forcepack.libs.pe.api.wrapper.PacketWrapper;

public class ParticleDustData
extends ParticleData {
    private float scale;
    private Color color;

    public ParticleDustData(float scale, float red, float green, float blue) {
        this(scale, new Color(red, green, blue));
    }

    public ParticleDustData(float scale, float[] rgb) {
        this(scale, rgb[0], rgb[1], rgb[2]);
    }

    public ParticleDustData(float scale, Vector3f rgb) {
        this(scale, rgb.getX(), rgb.getY(), rgb.getZ());
    }

    public ParticleDustData(float scale, int red, int green, int blue) {
        this(scale, new Color(red, green, blue));
    }

    public ParticleDustData(float scale, Color color) {
        this.scale = scale;
        this.color = color;
    }

    public static ParticleDustData read(PacketWrapper<?> wrapper) {
        Color color;
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            color = new Color(wrapper.readInt());
        } else {
            float red = wrapper.readFloat();
            float green = wrapper.readFloat();
            float blue = wrapper.readFloat();
            color = new Color(red, green, blue);
        }
        float scale = wrapper.readFloat();
        return new ParticleDustData(scale, color);
    }

    public static void write(PacketWrapper<?> wrapper, ParticleDustData data) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            wrapper.writeInt(data.color.asRGB());
        } else {
            wrapper.writeFloat(data.getRed());
            wrapper.writeFloat(data.getGreen());
            wrapper.writeFloat(data.getBlue());
        }
        wrapper.writeFloat(data.scale);
    }

    public static ParticleDustData decode(NBTCompound compound, ClientVersion version) {
        Color color = Color.decode(compound.getTagOrThrow("color"), version);
        float scale = compound.getNumberTagOrThrow("scale").getAsFloat();
        return new ParticleDustData(scale, color);
    }

    public static void encode(ParticleDustData data, ClientVersion version, NBTCompound compound) {
        compound.setTag("color", Color.encode(data.color, version));
        compound.setTag("scale", new NBTFloat(data.scale));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public float getRed() {
        return (float)this.color.red() / 255.0f;
    }

    public void setRed(float red) {
        this.color = new Color(red, this.getGreen(), this.getBlue());
    }

    public float getGreen() {
        return (float)this.color.green() / 255.0f;
    }

    public void setGreen(float green) {
        this.color = new Color(this.getRed(), green, this.getBlue());
    }

    public float getBlue() {
        return (float)this.color.blue() / 255.0f;
    }

    public void setBlue(float blue) {
        this.color = new Color(this.getRed(), this.getGreen(), blue);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

