/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.player;

import com.convallyria.forcepack.paper.libs.adventure.adventure.text.Component;
import com.convallyria.forcepack.paper.libs.adventure.adventure.text.TextComponent;
import forcepack.libs.pe.api.PacketEvents;
import forcepack.libs.pe.api.PacketEventsAPI;
import forcepack.libs.pe.api.manager.server.ServerVersion;
import forcepack.libs.pe.api.netty.channel.ChannelHelper;
import forcepack.libs.pe.api.protocol.ConnectionState;
import forcepack.libs.pe.api.protocol.chat.ChatType;
import forcepack.libs.pe.api.protocol.chat.ChatTypes;
import forcepack.libs.pe.api.protocol.chat.message.ChatMessage;
import forcepack.libs.pe.api.protocol.chat.message.ChatMessageLegacy;
import forcepack.libs.pe.api.protocol.chat.message.ChatMessage_v1_16;
import forcepack.libs.pe.api.protocol.nbt.NBTCompound;
import forcepack.libs.pe.api.protocol.nbt.NBTList;
import forcepack.libs.pe.api.protocol.player.ClientVersion;
import forcepack.libs.pe.api.protocol.player.UserProfile;
import forcepack.libs.pe.api.protocol.world.Dimension;
import forcepack.libs.pe.api.protocol.world.dimension.DimensionType;
import forcepack.libs.pe.api.protocol.world.dimension.DimensionTypes;
import forcepack.libs.pe.api.resources.ResourceLocation;
import forcepack.libs.pe.api.util.adventure.AdventureSerializer;
import forcepack.libs.pe.api.util.mappings.IRegistry;
import forcepack.libs.pe.api.util.mappings.IRegistryHolder;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerChatMessage;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerCloseWindow;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerSetTitleSubtitle;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerSetTitleText;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerSetTitleTimes;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerSystemChatMessage;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerTitle;
import forcepack.libs.pe.impl.adventure.serializer.legacy.LegacyComponentSerializer;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class User
implements IRegistryHolder {
    private final Object channel;
    private ConnectionState decoderState;
    private ConnectionState encoderState;
    private ClientVersion clientVersion;
    private final UserProfile profile;
    private int entityId = -1;
    private DimensionType dimensionType = DimensionTypes.OVERWORLD;
    private final Map<ResourceLocation, IRegistry<?>> registries = new HashMap();

    public User(Object channel, ConnectionState connectionState, ClientVersion clientVersion, UserProfile profile) {
        this.channel = channel;
        this.decoderState = connectionState;
        this.encoderState = connectionState;
        this.clientVersion = clientVersion;
        this.profile = profile;
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public IRegistry<?> getRegistry(ResourceLocation registryKey, ClientVersion version) {
        return this.registries.get(registryKey);
    }

    @ApiStatus.Internal
    public void putRegistry(IRegistry<?> registry) {
        this.registries.put(registry.getRegistryKey(), registry);
    }

    public Object getChannel() {
        return this.channel;
    }

    public InetSocketAddress getAddress() {
        return (InetSocketAddress)ChannelHelper.remoteAddress(this.channel);
    }

    @ApiStatus.Obsolete
    public ConnectionState getConnectionState() throws IllegalStateException {
        ConnectionState decoderState = this.decoderState;
        ConnectionState encoderState = this.encoderState;
        if (decoderState != encoderState) {
            throw new IllegalStateException("Can't get common connection state: " + (Object)((Object)decoderState) + " != " + (Object)((Object)encoderState));
        }
        return decoderState;
    }

    @ApiStatus.Internal
    public void setConnectionState(ConnectionState connectionState) {
        this.setDecoderState(connectionState);
        this.setEncoderState(connectionState);
    }

    public ConnectionState getDecoderState() {
        return this.decoderState;
    }

    @ApiStatus.Internal
    public void setDecoderState(ConnectionState decoderState) {
        this.decoderState = decoderState;
        PacketEvents.getAPI().getLogManager().debug("Transitioned " + this.getName() + "'s decoder into " + (Object)((Object)decoderState) + " state!");
    }

    public ConnectionState getEncoderState() {
        return this.encoderState;
    }

    @ApiStatus.Internal
    public void setEncoderState(ConnectionState encoderState) {
        this.encoderState = encoderState;
        PacketEvents.getAPI().getLogManager().debug("Transitioned " + this.getName() + "'s encoder into " + (Object)((Object)encoderState) + " state!");
    }

    public ClientVersion getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(ClientVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    public UserProfile getProfile() {
        return this.profile;
    }

    public String getName() {
        return this.profile.getName();
    }

    public UUID getUUID() {
        return this.profile.getUUID();
    }

    public int getEntityId() {
        return this.entityId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void sendPacket(Object buffer) {
        PacketEvents.getAPI().getProtocolManager().sendPacket(this.channel, buffer);
    }

    public void sendPacket(PacketWrapper<?> wrapper) {
        PacketEvents.getAPI().getProtocolManager().sendPacket(this.channel, wrapper);
    }

    public void sendPacketSilently(Object buffer) {
        PacketEvents.getAPI().getProtocolManager().sendPacketSilently(this.channel, buffer);
    }

    public void sendPacketSilently(PacketWrapper<?> wrapper) {
        PacketEvents.getAPI().getProtocolManager().sendPacketSilently(this.channel, wrapper);
    }

    public void writePacket(Object buffer) {
        PacketEvents.getAPI().getProtocolManager().writePacket(this.channel, buffer);
    }

    public void writePacket(PacketWrapper<?> wrapper) {
        PacketEvents.getAPI().getProtocolManager().writePacket(this.channel, wrapper);
    }

    public void writePacketSilently(Object buffer) {
        PacketEvents.getAPI().getProtocolManager().writePacketSilently(this.channel, buffer);
    }

    public void writePacketSilently(PacketWrapper<?> wrapper) {
        PacketEvents.getAPI().getProtocolManager().writePacketSilently(this.channel, wrapper);
    }

    public void receivePacket(Object buffer) {
        PacketEvents.getAPI().getProtocolManager().receivePacket(this.channel, buffer);
    }

    public void receivePacket(PacketWrapper<?> wrapper) {
        PacketEvents.getAPI().getProtocolManager().receivePacket(this.channel, wrapper);
    }

    public void receivePacketSilently(Object buffer) {
        PacketEvents.getAPI().getProtocolManager().receivePacketSilently(this.channel, buffer);
    }

    public void receivePacketSilently(PacketWrapper<?> wrapper) {
        PacketEvents.getAPI().getProtocolManager().receivePacketSilently(this.channel, wrapper);
    }

    public void flushPackets() {
        ChannelHelper.flush(this.channel);
    }

    public void closeConnection() {
        ChannelHelper.close(this.channel);
    }

    public void closeInventory() {
        WrapperPlayServerCloseWindow closeWindow = new WrapperPlayServerCloseWindow(0);
        PacketEvents.getAPI().getProtocolManager().sendPacket(this.channel, closeWindow);
    }

    public void sendMessage(String legacyMessage) {
        this.sendMessage(this.getSerializers().fromLegacy(legacyMessage));
    }

    public void sendMessage(Component component) {
        this.sendMessage(component, ChatTypes.CHAT);
    }

    public void sendMessage(Component component, ChatType type) {
        PacketWrapper chatPacket;
        ClientVersion version = this.getPacketVersion();
        if (version.isNewerThanOrEquals(ClientVersion.V_1_19)) {
            chatPacket = new WrapperPlayServerSystemChatMessage(false, component);
        } else {
            ChatMessage message = version.isNewerThanOrEquals(ClientVersion.V_1_16) ? new ChatMessage_v1_16(component, type, new UUID(0L, 0L)) : new ChatMessageLegacy(component, type);
            chatPacket = new WrapperPlayServerChatMessage(message);
        }
        PacketEvents.getAPI().getProtocolManager().sendPacket(this.channel, chatPacket);
    }

    public void sendTitle(String legacyTitle, String legacySubtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        LegacyComponentSerializer serializer = this.getSerializers().legacy();
        TextComponent title = serializer.deserialize(legacyTitle);
        TextComponent subtitle = serializer.deserialize(legacySubtitle);
        this.sendTitle(title, subtitle, fadeInTicks, stayTicks, fadeOutTicks);
    }

    public void sendTitle(Component title, Component subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        PacketWrapper animation;
        boolean modern = this.getPacketVersion().isNewerThanOrEquals(ClientVersion.V_1_17);
        PacketWrapper setTitle = null;
        PacketWrapper setSubtitle = null;
        if (modern) {
            animation = new WrapperPlayServerSetTitleTimes(fadeInTicks, stayTicks, fadeOutTicks);
            if (title != null) {
                setTitle = new WrapperPlayServerSetTitleText(title);
            }
            if (subtitle != null) {
                setSubtitle = new WrapperPlayServerSetTitleSubtitle(subtitle);
            }
        } else {
            animation = new WrapperPlayServerTitle(WrapperPlayServerTitle.TitleAction.SET_TIMES_AND_DISPLAY, (Component)null, null, null, fadeInTicks, stayTicks, fadeOutTicks);
            if (title != null) {
                setTitle = new WrapperPlayServerTitle(WrapperPlayServerTitle.TitleAction.SET_TITLE, title, null, null, 0, 0, 0);
            }
            if (subtitle != null) {
                setSubtitle = new WrapperPlayServerTitle(WrapperPlayServerTitle.TitleAction.SET_SUBTITLE, null, subtitle, null, 0, 0, 0);
            }
        }
        this.sendPacket(animation);
        if (setTitle != null) {
            this.sendPacket(setTitle);
        }
        if (setSubtitle != null) {
            this.sendPacket(setSubtitle);
        }
    }

    public ClientVersion getPacketVersion() {
        PacketEventsAPI<?> api = PacketEvents.getAPI();
        if (api.getInjector().isProxy()) {
            return this.getClientVersion();
        }
        return api.getServerManager().getVersion().toClientVersion();
    }

    public AdventureSerializer getSerializers() {
        return AdventureSerializer.serializer(this.getPacketVersion());
    }

    public int getMinWorldHeight() {
        return this.getMinWorldHeight(null);
    }

    public int getMinWorldHeight(@Nullable ClientVersion version) {
        if (version == null) {
            version = PacketEvents.getAPI().getInjector().isProxy() ? this.getClientVersion() : PacketEvents.getAPI().getServerManager().getVersion().toClientVersion();
        }
        return this.dimensionType.getMinY(version);
    }

    public int getTotalWorldHeight() {
        return this.getTotalWorldHeight(null);
    }

    public int getTotalWorldHeight(@Nullable ClientVersion version) {
        if (version == null) {
            version = PacketEvents.getAPI().getInjector().isProxy() ? this.getClientVersion() : PacketEvents.getAPI().getServerManager().getVersion().toClientVersion();
        }
        return this.dimensionType.getHeight(version);
    }

    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    @ApiStatus.Internal
    public void setDimensionType(DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    @Deprecated
    public void setMinWorldHeight(int minWorldHeight) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setTotalWorldHeight(int totalWorldHeight) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void switchDimensionType(ServerVersion version, Dimension dimension) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setDefaultWorldHeights(ServerVersion version, Dimension dimension) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setDefaultWorldHeights(boolean extended) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setWorldNBT(NBTList<NBTCompound> worldNBT) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Dimension getDimension() {
        return Dimension.fromDimensionType(this.dimensionType, this, null);
    }

    @Deprecated
    public void setDimension(Dimension dimension) {
        this.dimensionType = dimension.asDimensionType(this, null);
    }

    @Deprecated
    @Nullable
    public NBTCompound getWorldNBT(String worldName) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @Nullable
    public NBTCompound getWorldNBT(int worldId) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @Nullable
    public NBTCompound getWorldNBT(Dimension dimension) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @Nullable
    public String getWorldName(int worldId) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String getWorldName(Dimension dimension) {
        throw new UnsupportedOperationException();
    }
}

