/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.sound;

import forcepack.libs.pe.api.protocol.mapper.MappedEntity;
import forcepack.libs.pe.api.protocol.nbt.NBT;
import forcepack.libs.pe.api.protocol.nbt.NBTCompound;
import forcepack.libs.pe.api.protocol.nbt.NBTFloat;
import forcepack.libs.pe.api.protocol.nbt.NBTNumber;
import forcepack.libs.pe.api.protocol.nbt.NBTString;
import forcepack.libs.pe.api.protocol.player.ClientVersion;
import forcepack.libs.pe.api.protocol.sound.Sounds;
import forcepack.libs.pe.api.protocol.sound.StaticSound;
import forcepack.libs.pe.api.resources.ResourceLocation;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public interface Sound
extends MappedEntity {
    public ResourceLocation getSoundId();

    @Nullable
    public Float getRange();

    public static Sound read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(Sounds::getById, Sound::readDirect);
    }

    public static Sound readDirect(PacketWrapper<?> wrapper) {
        ResourceLocation soundId = wrapper.readIdentifier();
        Float range = (Float)wrapper.readOptional(PacketWrapper::readFloat);
        return new StaticSound(soundId, range);
    }

    public static void write(PacketWrapper<?> wrapper, Sound sound) {
        wrapper.writeMappedEntityOrDirect(sound, Sound::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, Sound sound) {
        wrapper.writeIdentifier(sound.getSoundId());
        wrapper.writeOptional(sound.getRange(), PacketWrapper::writeFloat);
    }

    @Deprecated
    public static Sound decode(NBT nbt, ClientVersion version) {
        return Sound.decode(nbt, PacketWrapper.createDummyWrapper(version));
    }

    public static Sound decode(NBT nbt, PacketWrapper<?> wrapper) {
        if (nbt instanceof NBTString) {
            return Sounds.getByNameOrCreate(((NBTString)nbt).getValue());
        }
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation soundId = new ResourceLocation(((NBTCompound)nbt).getStringTagValueOrThrow("sound_id"));
        Float range = Optional.ofNullable(compound.getNumberTagOrNull("range")).map(NBTNumber::getAsFloat).orElse(null);
        return new StaticSound(soundId, range);
    }

    @Deprecated
    public static NBT encode(Sound sound, ClientVersion version) {
        return Sound.encode(PacketWrapper.createDummyWrapper(version), sound);
    }

    public static NBT encode(PacketWrapper<?> wrapper, Sound sound) {
        if (sound.isRegistered()) {
            return new NBTString(sound.getName().toString());
        }
        NBTCompound compound = new NBTCompound();
        compound.setTag("sound_id", new NBTString(sound.getSoundId().toString()));
        if (sound.getRange() != null) {
            compound.setTag("range", new NBTFloat(sound.getRange().floatValue()));
        }
        return compound;
    }
}

