/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.world.damagetype;

import forcepack.libs.pe.api.protocol.mapper.CopyableEntity;
import forcepack.libs.pe.api.protocol.mapper.DeepComparableEntity;
import forcepack.libs.pe.api.protocol.mapper.MappedEntity;
import forcepack.libs.pe.api.protocol.nbt.NBT;
import forcepack.libs.pe.api.protocol.nbt.NBTCompound;
import forcepack.libs.pe.api.protocol.nbt.NBTFloat;
import forcepack.libs.pe.api.protocol.nbt.NBTString;
import forcepack.libs.pe.api.protocol.player.ClientVersion;
import forcepack.libs.pe.api.protocol.world.damagetype.DamageEffects;
import forcepack.libs.pe.api.protocol.world.damagetype.DamageScaling;
import forcepack.libs.pe.api.protocol.world.damagetype.DeathMessageType;
import forcepack.libs.pe.api.protocol.world.damagetype.StaticDamageType;
import forcepack.libs.pe.api.util.adventure.AdventureIndexUtil;
import forcepack.libs.pe.api.util.mappings.TypesBuilderData;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public interface DamageType
extends MappedEntity,
CopyableEntity<DamageType>,
DeepComparableEntity {
    public String getMessageId();

    public DamageScaling getScaling();

    public float getExhaustion();

    public DamageEffects getEffects();

    public DeathMessageType getDeathMessageType();

    public static DamageType decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        String messageId = ((NBTCompound)nbt).getStringTagValueOrThrow("message_id");
        DamageScaling scaling = AdventureIndexUtil.indexValueOrThrow(DamageScaling.ID_INDEX, ((NBTCompound)nbt).getStringTagValueOrThrow("scaling"));
        float exhaustion = ((NBTCompound)nbt).getNumberTagOrThrow("exhaustion").getAsFloat();
        DamageEffects effects = Optional.ofNullable(compound.getStringTagValueOrNull("effects")).map(id -> AdventureIndexUtil.indexValueOrThrow(DamageEffects.ID_INDEX, id)).orElse(DamageEffects.HURT);
        DeathMessageType deathMessageType = Optional.ofNullable(compound.getStringTagValueOrNull("death_message_type")).map(id -> AdventureIndexUtil.indexValueOrThrow(DeathMessageType.ID_INDEX, id)).orElse(DeathMessageType.DEFAULT);
        return new StaticDamageType(data, messageId, scaling, exhaustion, effects, deathMessageType);
    }

    public static NBT encode(DamageType damageType, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("message_id", new NBTString(damageType.getMessageId()));
        compound.setTag("scaling", new NBTString(damageType.getScaling().getId()));
        compound.setTag("exhaustion", new NBTFloat(damageType.getExhaustion()));
        if (damageType.getEffects() != DamageEffects.HURT) {
            compound.setTag("effects", new NBTString(damageType.getEffects().getId()));
        }
        if (damageType.getDeathMessageType() != DeathMessageType.DEFAULT) {
            compound.setTag("death_message_type", new NBTString(damageType.getDeathMessageType().getId()));
        }
        return compound;
    }
}

