/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.util;

import forcepack.libs.pe.api.manager.server.ServerVersion;
import forcepack.libs.pe.api.protocol.player.Equipment;
import forcepack.libs.pe.api.protocol.world.chunk.LightData;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerChunkData;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerDestroyEntities;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerEntityEquipment;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerSetCursorItem;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerSetPlayerInventory;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerSetSlot;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerUpdateLight;
import java.util.Collections;

public class PacketTransformationUtil {
    public static PacketWrapper<?>[] transform(PacketWrapper<?> wrapper) {
        if (wrapper instanceof WrapperPlayServerDestroyEntities) {
            WrapperPlayServerDestroyEntities destroyEntities = (WrapperPlayServerDestroyEntities)wrapper;
            int len = destroyEntities.getEntityIds().length;
            if (wrapper.getServerVersion() == ServerVersion.V_1_17 && len > 1) {
                PacketWrapper[] output = new PacketWrapper[len];
                for (int i = 0; i < len; ++i) {
                    int entityId = destroyEntities.getEntityIds()[i];
                    output[i] = new WrapperPlayServerDestroyEntities(entityId);
                }
                return output;
            }
        } else if (wrapper instanceof WrapperPlayServerEntityEquipment) {
            WrapperPlayServerEntityEquipment entityEquipment = (WrapperPlayServerEntityEquipment)wrapper;
            int len = entityEquipment.getEquipment().size();
            if (entityEquipment.getServerVersion().isOlderThan(ServerVersion.V_1_16) && len > 1) {
                PacketWrapper[] output = new PacketWrapper[len];
                for (int i = 0; i < len; ++i) {
                    Equipment equipment = entityEquipment.getEquipment().get(i);
                    output[i] = new WrapperPlayServerEntityEquipment(entityEquipment.getEntityId(), Collections.singletonList(equipment));
                }
                return output;
            }
        } else if (wrapper instanceof WrapperPlayServerChunkData) {
            WrapperPlayServerChunkData chunkData = (WrapperPlayServerChunkData)wrapper;
            LightData lightData = chunkData.getLightData();
            if (chunkData.getServerVersion().isOlderThan(ServerVersion.V_1_18) && lightData != null) {
                PacketWrapper[] output = new PacketWrapper[]{new WrapperPlayServerUpdateLight(chunkData.getColumn().getX(), chunkData.getColumn().getZ(), lightData), chunkData};
                return output;
            }
        } else if (wrapper instanceof WrapperPlayServerSetSlot) {
            WrapperPlayServerSetSlot setSlot = (WrapperPlayServerSetSlot)wrapper;
            if (setSlot.getSlot() == -1) {
                if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
                    wrapper = new WrapperPlayServerSetCursorItem(setSlot.getItem());
                }
            } else if (setSlot.getWindowId() == -2 && wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
                wrapper = new WrapperPlayServerSetPlayerInventory(setSlot.getSlot(), setSlot.getItem());
            }
        }
        return new PacketWrapper[]{wrapper};
    }
}

