/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.relocator;

import forcepack.libs.asm.commons.Remapper;
import forcepack.libs.relocator.Relocation;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class RelocatingRemapper
extends Remapper {
    private static final Pattern CLASS_PATTERN = Pattern.compile("(\\[*)?L(.+);");
    private final Collection<Relocation> rules;

    RelocatingRemapper(Collection<Relocation> rules) {
        this.rules = rules;
    }

    @Override
    public Object mapValue(Object object) {
        String relocatedName;
        if (object instanceof String && (relocatedName = this.relocate((String)object, true)) != null) {
            return relocatedName;
        }
        return super.mapValue(object);
    }

    @Override
    public String map(String name) {
        String relocatedName = this.relocate(name, false);
        if (relocatedName != null) {
            return relocatedName;
        }
        return super.map(name);
    }

    private String relocate(String name, boolean isClass) {
        String prefix = "";
        String suffix = "";
        Matcher m = CLASS_PATTERN.matcher(name);
        if (m.matches()) {
            prefix = m.group(1) + "L";
            suffix = ";";
            name = m.group(2);
        }
        for (Relocation r : this.rules) {
            if (isClass && r.canRelocateClass(name)) {
                return prefix + r.relocateClass(name) + suffix;
            }
            if (!r.canRelocatePath(name)) continue;
            return prefix + r.relocatePath(name) + suffix;
        }
        return null;
    }
}

