/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.api;

import com.convallyria.forcepack.api.ForcePackAPI;
import com.convallyria.forcepack.api.resourcepack.PackFormatResolver;
import com.convallyria.forcepack.api.resourcepack.ResourcePack;
import com.convallyria.forcepack.api.resourcepack.ResourcePackVersion;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface ForcePackPlatform
extends ForcePackAPI {
    default public boolean isDefaultHost(String url) {
        List<String> warnForHost = List.of("convallyria.com");
        for (String host : warnForHost) {
            if (!url.contains(host)) continue;
            return true;
        }
        return false;
    }

    default public Optional<String> getBlacklistedSite(String url) {
        List<String> blacklisted = List.of("mediafire.com");
        for (String blacklistedSite : blacklisted) {
            if (!url.contains(blacklistedSite)) continue;
            return Optional.of(url);
        }
        return Optional.empty();
    }

    default public boolean isValidEnding(String url) {
        List<String> validUrlEndings = Arrays.asList(".zip", "dl=1");
        boolean hasEnding = false;
        for (String validUrlEnding : validUrlEndings) {
            if (!url.endsWith(validUrlEnding)) continue;
            hasEnding = true;
            break;
        }
        return hasEnding;
    }

    default public ResourcePackVersion getVersionFromId(String versionId) {
        if (versionId.equals("all")) {
            return null;
        }
        try {
            double fixedVersion = Double.parseDouble(versionId);
            return ResourcePackVersion.of(fixedVersion, fixedVersion);
        }
        catch (NumberFormatException ignored) {
            try {
                String[] ranged = versionId.split("-");
                double min = Double.parseDouble(ranged[0]);
                double max = Double.parseDouble(ranged[1]);
                return ResourcePackVersion.of(min, max);
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                throw new IllegalArgumentException("Invalid version id: " + versionId);
            }
        }
    }

    default public Set<ResourcePack> getPacksForVersion(int protocolVersion) {
        double packFormat = PackFormatResolver.getPackFormat(protocolVersion);
        this.log("Searching for a resource pack with pack version %f", packFormat);
        Set<Object> validPacks = new HashSet();
        boolean hasVersionOverride = false;
        for (ResourcePack resourcePack : this.getResourcePacks()) {
            Optional<ResourcePackVersion> version = resourcePack.getVersion();
            this.log("Trying resource pack " + resourcePack.getURL() + " (" + (version.isEmpty() ? version.toString() : version.get().toString()) + ")", new Object[0]);
            boolean inVersion = version.isEmpty() || version.get().inVersion(packFormat);
            if (!inVersion) continue;
            if (version.isPresent()) {
                hasVersionOverride = true;
            }
            validPacks.add(resourcePack);
            this.log("Added resource pack " + resourcePack.getURL(), new Object[0]);
            if (protocolVersion >= 765) continue;
            break;
        }
        if (!validPacks.isEmpty()) {
            this.log("Found valid resource packs (" + validPacks.size() + ")", new Object[0]);
            if (hasVersionOverride) {
                validPacks = validPacks.stream().filter(pack -> pack.getVersion().isPresent()).collect(Collectors.toSet());
            }
            this.log("Found valid resource packs (filtered to: " + validPacks.size() + ")", new Object[0]);
            for (ResourcePack resourcePack : validPacks) {
                this.log("Chosen resource pack " + resourcePack.getURL(), new Object[0]);
            }
            return validPacks;
        }
        this.log("No valid resource packs found", new Object[0]);
        return null;
    }

    public void log(String var1, Object ... var2);
}

