/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.api.resourcepack;

import com.convallyria.forcepack.api.ForcePackAPI;
import com.convallyria.forcepack.api.resourcepack.IResourcePack;
import com.convallyria.forcepack.api.resourcepack.ResourcePackVersion;
import com.convallyria.forcepack.api.utils.HashingUtil;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ResourcePack
implements IResourcePack {
    protected final ForcePackAPI plugin;
    protected final UUID uuid;
    protected final String server;
    protected final String url;
    protected final String hash;
    protected final int size;
    protected final ResourcePackVersion packVersion;

    public ResourcePack(ForcePackAPI plugin, String server, String url, String hash, int size, @Nullable ResourcePackVersion packVersion) {
        this.plugin = plugin;
        this.server = server;
        this.uuid = UUID.nameUUIDFromBytes((url + hash).getBytes(StandardCharsets.UTF_8));
        this.url = url;
        this.hash = hash;
        this.size = size;
        this.packVersion = packVersion;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public byte[] getHashSum() {
        return HashingUtil.toByteArray(this.hash);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public Optional<ResourcePackVersion> getVersion() {
        return Optional.ofNullable(this.packVersion);
    }

    @Override
    public abstract void setResourcePack(UUID var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourcePack)) {
            return false;
        }
        ResourcePack that = (ResourcePack)o;
        return Objects.equals(this.uuid, that.uuid) && Objects.equals(this.getServer(), that.getServer());
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.getServer());
    }
}

