/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.folia.schedule;

import com.convallyria.forcepack.api.ForcePackAPI;
import com.convallyria.forcepack.api.schedule.PlatformScheduler;
import io.papermc.paper.threadedregions.RegionizedServerInitEvent;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class FoliaScheduler
extends PlatformScheduler<ForcePackAPI>
implements Listener {
    public static final boolean RUNNING_FOLIA;
    private List<Runnable> initTasks = new ArrayList<Runnable>();

    public FoliaScheduler(ForcePackAPI api) {
        super(api);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)api);
    }

    @EventHandler
    public void onServerInit(RegionizedServerInitEvent event) {
        for (Runnable tasks : this.initTasks) {
            tasks.run();
        }
        this.initTasks = null;
    }

    @Override
    public void executeOnMain(Runnable runnable) {
        Bukkit.getGlobalRegionScheduler().execute((Plugin)this.api, runnable);
    }

    @Override
    public void executeAsync(Runnable runnable) {
        Bukkit.getAsyncScheduler().runNow((Plugin)this.api, s -> runnable.run());
    }

    @Override
    public PlatformScheduler.ForcePackTask executeRepeating(Runnable runnable, long delay, long period) {
        ScheduledTask task = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.api, s -> runnable.run(), delay, period);
        return () -> ((ScheduledTask)task).cancel();
    }

    @Override
    public void executeDelayed(Runnable runnable, long delay) {
        Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.api, s -> runnable.run(), delay);
    }

    @Override
    public void registerInitTask(Runnable runnable) {
        if (this.initTasks == null) {
            throw new IllegalStateException("Server already initialised!");
        }
        this.initTasks.add(runnable);
    }

    static {
        boolean found;
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServerInitEvent");
            found = true;
        }
        catch (ReflectiveOperationException e) {
            found = false;
        }
        RUNNING_FOLIA = found;
    }
}

