/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.paper.libs.languagy.api.language.translation;

import com.convallyria.forcepack.paper.libs.adventure.adventure.text.Component;
import com.convallyria.forcepack.paper.libs.adventure.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.convallyria.forcepack.paper.libs.languagy.api.adventure.AdventurePlatform;
import com.convallyria.forcepack.paper.libs.languagy.api.language.Language;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class Translation {
    private final Player player;
    private final Language language;
    private final List<String> translations;
    @Nullable
    private final AdventurePlatform adventure;

    private Translation(Player player, Language language, List<String> translations, @Nullable AdventurePlatform adventure) {
        this.player = player;
        this.language = language;
        this.translations = translations;
        this.adventure = adventure;
    }

    @Deprecated
    public static Translation of(Player player, Language language, String translation) {
        return Translation.of(player, language, translation, null);
    }

    public static Translation of(Player player, Language language, String translation, @Nullable AdventurePlatform adventure) {
        return Translation.of(player, language, Lists.newArrayList((Object[])new String[]{translation}), adventure);
    }

    @Deprecated
    public static Translation of(Player player, Language language, List<String> translations) {
        return Translation.of(player, language, translations, null);
    }

    public static Translation of(Player player, Language language, List<String> translations, @Nullable AdventurePlatform adventure) {
        return new Translation(player, language, translations, adventure);
    }

    public Language getLanguage() {
        return this.language;
    }

    @Nullable
    public AdventurePlatform getAdventure() {
        return this.adventure;
    }

    public void send() {
        if (this.adventure == null) {
            this.sendLegacy();
            return;
        }
        this.colour().forEach(component -> this.adventure.adventure().player(this.player).sendMessage((Component)component));
    }

    @Deprecated
    public void sendLegacy() {
        this.legacyColour().forEach(arg_0 -> ((Player)this.player).sendMessage(arg_0));
    }

    public void format(Object ... values) {
        this.translations.replaceAll(s -> String.format(Locale.ROOT, s, values));
    }

    public List<String> getTranslations() {
        return this.translations;
    }

    public List<Component> colour() {
        ArrayList colouredText = Lists.newArrayList();
        this.translations.forEach(translation -> {
            if (!translation.isEmpty()) {
                if (this.adventure != null) {
                    Object component = this.adventure.miniMessage().deserialize(translation);
                    colouredText.add(component);
                } else {
                    colouredText.add(LegacyComponentSerializer.legacyAmpersand().deserialize((String)translation));
                }
            }
        });
        return colouredText;
    }

    @Deprecated
    public List<String> legacyColour() {
        ArrayList colouredText = Lists.newArrayList();
        this.translations.forEach(translation -> {
            if (!translation.isEmpty()) {
                colouredText.add(this.legacyColour((String)translation));
            }
        });
        return colouredText;
    }

    @Deprecated
    private String legacyColour(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

