/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.paper.listener;

import com.convallyria.forcepack.paper.ForcePackPaper;
import com.convallyria.forcepack.paper.event.MultiVersionResourcePackStatusEvent;
import com.convallyria.forcepack.paper.libs.adventure.adventure.resource.ResourcePackStatus;
import forcepack.libs.pe.api.event.PacketListenerAbstract;
import forcepack.libs.pe.api.event.PacketReceiveEvent;
import forcepack.libs.pe.api.protocol.packettype.PacketType;
import forcepack.libs.pe.api.wrapper.play.client.WrapperPlayClientResourcePackStatus;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PacketListener
extends PacketListenerAbstract {
    private final ForcePackPaper plugin;

    public PacketListener(ForcePackPaper plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isPreVia() {
        return true;
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.RESOURCE_PACK_STATUS) {
            Player player = Bukkit.getPlayer((UUID)event.getUser().getUUID());
            if (player == null) {
                this.plugin.getLogger().warning("Unable to get player for resource pack status!?!? " + String.valueOf(event.getUser()) + ", " + String.valueOf(event.getPlayer()));
                return;
            }
            this.plugin.log("Received packet resource pack status from " + player.getName() + " (version: " + event.getServerVersion().getReleaseName() + ")", new Object[0]);
            WrapperPlayClientResourcePackStatus status = new WrapperPlayClientResourcePackStatus(event);
            WrapperPlayClientResourcePackStatus.Result result = status.getResult();
            UUID packId = status.getPackId();
            MultiVersionResourcePackStatusEvent packEvent = new MultiVersionResourcePackStatusEvent(player, packId, ResourcePackStatus.valueOf(result.name()), false, false);
            Bukkit.getPluginManager().callEvent((Event)packEvent);
            event.setCancelled(packEvent.isCancelled());
        }
    }
}

