/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.paper.listener;

import com.convallyria.forcepack.api.check.SpoofCheck;
import com.convallyria.forcepack.api.player.ForcePackPlayer;
import com.convallyria.forcepack.api.resourcepack.ResourcePack;
import com.convallyria.forcepack.api.schedule.PlatformScheduler;
import com.convallyria.forcepack.api.utils.ClientVersion;
import com.convallyria.forcepack.api.utils.GeyserUtil;
import com.convallyria.forcepack.paper.ForcePackPaper;
import com.convallyria.forcepack.paper.event.ForcePackReloadEvent;
import com.convallyria.forcepack.paper.event.MultiVersionResourcePackStatusEvent;
import com.convallyria.forcepack.paper.libs.adventure.adventure.resource.ResourcePackStatus;
import com.convallyria.forcepack.paper.translation.Translations;
import com.convallyria.forcepack.paper.util.ProtocolUtil;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;

public class ResourcePackListener
implements Listener {
    private final ForcePackPaper plugin;
    private final Map<UUID, Long> sentAccept = new ConcurrentHashMap<UUID, Long>();
    private static final Constructor<PlayerResourcePackStatusEvent> LEGACY_CONSTRUCTOR;

    public ResourcePackListener(ForcePackPaper plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onStatus(MultiVersionResourcePackStatusEvent event) {
        Player player = event.getPlayer();
        UUID id = event.getID();
        boolean geyser = this.plugin.getConfig().getBoolean("Server.geyser") && GeyserUtil.isBedrockPlayer(player.getUniqueId());
        boolean canBypass = player.hasPermission("forcepack.bypass") && this.getConfig().getBoolean("Server.bypass-permission");
        this.plugin.log(player.getName() + "'s exemptions: geyser, " + geyser + ". permission, " + canBypass + ".", new Object[0]);
        if (canBypass || geyser) {
            return;
        }
        if (this.plugin.temporaryExemptedPlayers.remove(player.getUniqueId())) {
            this.plugin.log("Ignoring player " + player.getName() + " as they have a one-off exemption.", new Object[0]);
            return;
        }
        ResourcePackStatus status = event.getStatus();
        this.plugin.log(player.getName() + " sent status: " + String.valueOf((Object)status), new Object[0]);
        if (!this.plugin.velocityMode && this.tryValidateHacks(player, event, status)) {
            return;
        }
        if (!event.isProxy() && !this.plugin.isWaitingFor(player, id)) {
            this.plugin.log("Ignoring resource pack " + String.valueOf(id) + " because it wasn't set by ForcePack.", new Object[0]);
            return;
        }
        if (event.isProxy()) {
            this.plugin.log("Resource pack with id " + String.valueOf(id) + " sent by proxy.", new Object[0]);
        }
        if (status != ResourcePackStatus.ACCEPTED && status != ResourcePackStatus.DOWNLOADED) {
            if (event.isProxy()) {
                if (event.isProxyRemove()) {
                    this.plugin.removeFromWaiting(player);
                }
            } else {
                this.plugin.processWaitingResourcePack(player, id);
            }
        }
        for (String cmd : this.getConfig().getStringList("Server.Actions." + status.name() + ".Commands")) {
            this.ensureMainThread(() -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), cmd.replace("[player]", player.getName())));
        }
        if (this.plugin.velocityMode) {
            this.plugin.getScheduler().executeOnMain(() -> this.callBukkitEvent(event));
            return;
        }
        boolean kick = this.getConfig().getBoolean("Server.Actions." + status.name() + ".kick");
        switch (status) {
            case ACCEPTED: {
                this.sentAccept.put(player.getUniqueId(), System.currentTimeMillis());
                break;
            }
            case DECLINED: {
                this.ensureMainThread(() -> {
                    if (kick) {
                        player.kickPlayer(Translations.DECLINED.get(player));
                    } else {
                        Translations.DECLINED.send(player, new Object[0]);
                    }
                });
                this.sentAccept.remove(player.getUniqueId());
                break;
            }
            case DISCARDED: 
            case INVALID_URL: 
            case FAILED_RELOAD: 
            case FAILED_DOWNLOAD: {
                this.ensureMainThread(() -> {
                    if (kick) {
                        player.kickPlayer(Translations.DOWNLOAD_FAILED.get(player));
                    } else {
                        Translations.DOWNLOAD_FAILED.send(player, new Object[0]);
                    }
                });
                this.sentAccept.remove(player.getUniqueId());
                break;
            }
            case SUCCESSFULLY_LOADED: {
                if (kick) {
                    this.ensureMainThread(() -> player.kickPlayer(Translations.ACCEPTED.get(player)));
                    break;
                }
                this.ensureMainThread(() -> Translations.ACCEPTED.send(player, new Object[0]));
                boolean sendTitle = this.plugin.getConfig().getBoolean("send-loading-title");
                if (!sendTitle) break;
                player.sendTitle(null, null, 0, 0, 0);
            }
        }
    }

    private boolean tryValidateHacks(Player player, MultiVersionResourcePackStatusEvent event, ResourcePackStatus status) {
        boolean tryPrevent = this.getConfig().getBoolean("try-to-stop-fake-accept-hacks", true);
        if (!tryPrevent) {
            return false;
        }
        ForcePackPlayer forcePackPlayer = this.plugin.getForcePackPlayer(player).orElse(null);
        if (forcePackPlayer == null) {
            this.plugin.log("Not checking " + player.getName() + " because they are not in waiting.", new Object[0]);
            return false;
        }
        boolean hasFailed = false;
        for (SpoofCheck check : forcePackPlayer.getChecks()) {
            SpoofCheck.CheckStatus checkStatus = check.receiveStatus(status.name(), x$0 -> this.plugin.log((String)x$0, new Object[0]));
            boolean bl = hasFailed = checkStatus == SpoofCheck.CheckStatus.FAILED;
            if (checkStatus != SpoofCheck.CheckStatus.CANCEL) continue;
            this.plugin.log("Cancelling status " + String.valueOf((Object)status) + " as a check requested it.", new Object[0]);
            event.setCancelled(true);
            return true;
        }
        if (hasFailed) {
            this.plugin.log("Kicking player " + player.getName() + " because they failed a check.", new Object[0]);
            this.ensureMainThread(() -> player.kickPlayer(Translations.DOWNLOAD_FAILED.get(player)));
        }
        return hasFailed;
    }

    private void callBukkitEvent(MultiVersionResourcePackStatusEvent event) {
        PlayerResourcePackStatusEvent bukkit;
        PlayerResourcePackStatusEvent.Status bukkitStatus;
        try {
            bukkitStatus = PlayerResourcePackStatusEvent.Status.valueOf((String)event.getStatus().name());
        }
        catch (IllegalArgumentException ignored) {
            return;
        }
        try {
            bukkit = new PlayerResourcePackStatusEvent(event.getPlayer(), event.getID() == null ? UUID.randomUUID() : event.getID(), bukkitStatus);
        }
        catch (NoSuchMethodError ignored) {
            try {
                bukkit = LEGACY_CONSTRUCTOR.newInstance(event.getPlayer(), bukkitStatus);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        Bukkit.getPluginManager().callEvent((Event)bukkit);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC") || player.hasMetadata("fake-player")) {
            return;
        }
        boolean geyser = this.plugin.getConfig().getBoolean("Server.geyser") && GeyserUtil.isBedrockPlayer(player.getUniqueId());
        boolean canBypass = player.hasPermission("forcepack.bypass") && this.getConfig().getBoolean("Server.bypass-permission");
        this.plugin.log(player.getName() + "'s exemptions: geyser, " + geyser + ". permission, " + canBypass + ".", new Object[0]);
        if (canBypass || geyser) {
            return;
        }
        if (this.plugin.velocityMode) {
            this.plugin.log("Velocity mode is enabled", new Object[0]);
            this.plugin.addToWaiting(player.getUniqueId(), Set.of());
            return;
        }
        Set<ResourcePack> packs = this.plugin.getPacksForVersion(player);
        if (packs.isEmpty()) {
            this.plugin.log("Warning: Packs for player " + player.getName() + " are empty.", new Object[0]);
            return;
        }
        this.plugin.addToWaiting(player.getUniqueId(), packs);
        for (ResourcePack pack : packs) {
            this.plugin.log("Sending pack " + String.valueOf(pack.getUUID()) + " to player " + player.getName(), new Object[0]);
            int version = ProtocolUtil.getProtocolVersion(player);
            int maxSize = ClientVersion.getMaxSizeForVersion(version);
            boolean forceSend = this.getConfig().getBoolean("Server.force-invalid-size");
            if (!forceSend && pack.getSize() > maxSize) {
                if (!this.plugin.debug()) continue;
                this.plugin.getLogger().info(String.format("Not sending pack to %s because of excessive size for version %d (%dMB, %dMB).", player.getName(), version, pack.getSize(), maxSize));
                continue;
            }
            this.plugin.getScheduler().executeOnMain(() -> this.runSetPackTask(player, pack, version));
        }
    }

    @EventHandler
    public void onReload(ForcePackReloadEvent event) {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (this.plugin.isWaiting(onlinePlayer)) continue;
            this.sentAccept.remove(onlinePlayer.getUniqueId());
        }
    }

    private void runSetPackTask(Player player, ResourcePack pack, int version) {
        AtomicReference<PlatformScheduler.ForcePackTask> task = new AtomicReference<PlatformScheduler.ForcePackTask>();
        Runnable packTask = () -> {
            PlatformScheduler.ForcePackTask acquired;
            boolean sendTitle;
            if (this.plugin.isWaiting(player)) {
                this.plugin.log("Sent resource pack to player", new Object[0]);
                pack.setResourcePack(player.getUniqueId());
            }
            if ((sendTitle = this.plugin.getConfig().getBoolean("send-loading-title")) && this.sentAccept.containsKey(player.getUniqueId())) {
                player.sendTitle(Translations.DOWNLOAD_START_TITLE.get(player), Translations.DOWNLOAD_START_SUBTITLE.get(player), 0, 30, 10);
            }
            if ((acquired = (PlatformScheduler.ForcePackTask)task.get()) != null && !this.plugin.isWaiting(player) && !this.sentAccept.containsKey(player.getUniqueId())) {
                acquired.cancel();
            }
        };
        if (this.getConfig().getBoolean("Server.Update GUI") && version <= 340) {
            task.set(this.plugin.getScheduler().executeRepeating(packTask, 0L, this.getConfig().getInt("Server.Update GUI Speed", 20)));
        } else {
            packTask.run();
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent pqe) {
        Player player = pqe.getPlayer();
        this.plugin.removeFromWaiting(player);
        this.sentAccept.remove(player.getUniqueId());
        this.plugin.temporaryExemptedPlayers.remove(player.getUniqueId());
    }

    private void ensureMainThread(Runnable runnable) {
        this.plugin.getScheduler().executeOnMain(runnable);
    }

    private FileConfiguration getConfig() {
        return this.plugin.getConfig();
    }

    static {
        Constructor constructor;
        try {
            constructor = PlayerResourcePackStatusEvent.class.getConstructor(Player.class, PlayerResourcePackStatusEvent.Status.class);
        }
        catch (NoSuchMethodException ignored) {
            constructor = null;
        }
        LEGACY_CONSTRUCTOR = constructor;
    }
}

