/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.velocity.handler;

import com.convallyria.forcepack.api.player.ForcePackPlayer;
import com.convallyria.forcepack.api.resourcepack.ResourcePack;
import com.convallyria.forcepack.api.utils.ClientVersion;
import com.convallyria.forcepack.api.utils.GeyserUtil;
import com.convallyria.forcepack.velocity.ForcePackVelocity;
import com.convallyria.forcepack.velocity.config.VelocityConfig;
import com.convallyria.forcepack.velocity.player.ForcePackVelocityPlayer;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import com.velocitypowered.api.proxy.server.ServerInfo;
import com.velocitypowered.api.scheduler.ScheduledTask;
import com.velocitypowered.api.scheduler.Scheduler;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.kyori.adventure.resource.ResourcePackStatus;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PackHandler {
    public static final MinecraftChannelIdentifier FORCEPACK_STATUS_IDENTIFIER = MinecraftChannelIdentifier.create((String)"forcepack", (String)"status");
    private final ForcePackVelocity plugin;
    private final Map<UUID, ForcePackPlayer> waiting;

    public PackHandler(ForcePackVelocity plugin) {
        this.plugin = plugin;
        this.waiting = new ConcurrentHashMap<UUID, ForcePackPlayer>();
    }

    public void processWaitingResourcePack(Player player, UUID packId) {
        UUID playerId = player.getUniqueId();
        if (player.getProtocolVersion().getProtocol() < ProtocolVersion.MINECRAFT_1_20_3.getProtocol()) {
            this.removeFromWaiting(player);
            return;
        }
        ForcePackPlayer newPlayer = this.waiting.computeIfPresent(playerId, (a, forcePackPlayer) -> {
            forcePackPlayer.getWaitingPacks().removeIf(pack -> pack.getUUID().equals(packId));
            return forcePackPlayer;
        });
        if (newPlayer == null || newPlayer.getWaitingPacks().isEmpty()) {
            this.removeFromWaiting(player);
        }
    }

    public boolean isWaiting(Player player) {
        return this.waiting.containsKey(player.getUniqueId());
    }

    public boolean isWaitingFor(Player player, @Nullable UUID packId) {
        if (!this.isWaiting(player)) {
            return false;
        }
        if (player.getProtocolVersion().getProtocol() < ProtocolVersion.MINECRAFT_1_20_3.getProtocol() || packId == null) {
            return true;
        }
        ForcePackPlayer forcePackPlayer = this.waiting.get(player.getUniqueId());
        Set<ResourcePack> waitingPacks = forcePackPlayer.getWaitingPacks();
        return waitingPacks.stream().anyMatch(pack -> pack.getUUID().equals(packId));
    }

    public void removeFromWaiting(Player player) {
        this.waiting.remove(player.getUniqueId());
    }

    public void addToWaiting(Player player, @NonNull Set<ResourcePack> packs) {
        this.waiting.compute(player.getUniqueId(), (a, existing) -> {
            ForcePackPlayer newPlayer = existing != null ? existing : new ForcePackVelocityPlayer(this.plugin, player);
            newPlayer.getWaitingPacks().addAll(packs);
            return newPlayer;
        });
    }

    public void setPack(Player player, ServerConnection server) {
        boolean geyser = this.plugin.getConfig().getBoolean("geyser") && GeyserUtil.isBedrockPlayer(player.getUniqueId());
        boolean canBypass = player.hasPermission("forcepack.bypass") && this.plugin.getConfig().getBoolean("bypass-permission");
        this.plugin.log(player.getUsername() + "'s exemptions: geyser, " + geyser + ". permission, " + canBypass + ".", new Object[0]);
        if (canBypass || geyser) {
            return;
        }
        ServerInfo serverInfo = server.getServerInfo();
        ProtocolVersion protocolVersion = player.getProtocolVersion();
        int protocol = protocolVersion.getProtocol();
        this.plugin.getPacksByServerAndVersion(serverInfo.getName(), protocolVersion).ifPresentOrElse(resourcePacks -> {
            boolean forceApply;
            boolean bl = forceApply = protocol != ProtocolVersion.MINECRAFT_1_20_2.getProtocol() && this.plugin.getConfig().getBoolean("force-constant-download", false);
            if (protocol >= ProtocolVersion.MINECRAFT_1_20_3.getProtocol()) {
                player.getAppliedResourcePacks().stream().filter(pack -> forceApply || resourcePacks.stream().noneMatch(pack2 -> pack2.getUUID().equals(pack.getId()))).forEach(toRemove -> {
                    this.plugin.log("Removing resource pack %s from %s", toRemove.getId(), player.getUsername());
                    player.removeResourcePacks(toRemove.getId(), new UUID[0]);
                });
            }
            int maxSize = ClientVersion.getMaxSizeForVersion(protocol);
            boolean forceSend = this.plugin.getConfig().getBoolean("force-invalid-size", false);
            resourcePacks.stream().filter(pack -> {
                if (forceApply) {
                    return true;
                }
                for (ResourcePackInfo applied : player.getAppliedResourcePacks()) {
                    this.plugin.log("Checking applied pack %s on %s", applied.getId().toString(), player.getUsername());
                    if (!Arrays.equals(applied.getHash(), pack.getHashSum())) continue;
                    this.plugin.log("Not applying already applied pack '" + pack.getUUID().toString() + "' to player " + player.getUsername() + ".", new Object[0]);
                    server.sendPluginMessage((ChannelIdentifier)FORCEPACK_STATUS_IDENTIFIER, (pack.getUUID().toString() + ";SUCCESSFULLY_LOADED;true").getBytes(StandardCharsets.UTF_8));
                    this.plugin.log("Sent player '%s' plugin message downstream to '%s' for status '%s'", player.getUsername(), serverInfo.getName(), ResourcePackStatus.SUCCESSFULLY_LOADED.name());
                    return false;
                }
                if (player.getAppliedResourcePacks().isEmpty()) {
                    this.plugin.log("Player %s doesn't have any applied resource packs!", player.getUsername());
                }
                if (!forceSend && pack.getSize() > maxSize) {
                    this.plugin.log(String.format("Not sending pack %s to %s because of excessive size for version %d (%dMB, %dMB).", pack.getUUID().toString(), player.getUsername(), protocol, pack.getSize(), maxSize), new Object[0]);
                    return false;
                }
                return true;
            }).forEach(toApply -> this.runSetPackTask(player, (ResourcePack)toApply, protocol));
        }, () -> {
            if (protocol >= ProtocolVersion.MINECRAFT_1_20_3.getProtocol()) {
                player.clearResourcePacks();
                this.plugin.log("Removing all resource packs from %s", player.getUsername());
                return;
            }
            ResourcePackInfo appliedResourcePack = player.getAppliedResourcePack();
            if (appliedResourcePack == null && protocol != ProtocolVersion.MINECRAFT_1_20_2.getProtocol()) {
                this.plugin.log("%s doesn't have a resource pack applied, not sending unload.", player.getUsername());
                return;
            }
            VelocityConfig unloadPack = this.plugin.getConfig().getConfig("unload-pack");
            boolean enableUnload = unloadPack.getBoolean("enable");
            if (!enableUnload) {
                this.plugin.log("Unload pack is disabled, not sending for server %s, user %s.", serverInfo.getName(), player.getUsername());
                return;
            }
            List<String> excluded = unloadPack.getStringList("exclude");
            if (excluded.contains(serverInfo.getName())) {
                return;
            }
            this.plugin.getPacksByServerAndVersion("ForcePack-Empty-Server", player.getProtocolVersion()).ifPresent(packs -> {
                for (ResourcePack empty : packs) {
                    if (appliedResourcePack == null || appliedResourcePack.getUrl().equals(empty.getURL())) {
                        return;
                    }
                    empty.setResourcePack(player.getUniqueId());
                }
            });
        });
    }

    private void runSetPackTask(Player player, ResourcePack resourcePack, int protocol) {
        boolean update = this.plugin.getConfig().getBoolean("update-gui", true);
        AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Scheduler.TaskBuilder builder = this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> {
            for (ResourcePackInfo appliedResourcePack : player.getAppliedResourcePacks()) {
                if (!Arrays.equals(appliedResourcePack.getHash(), resourcePack.getHashSum()) || task.get() == null) continue;
                ((ScheduledTask)task.get()).cancel();
            }
            this.plugin.log("Applying resource pack " + resourcePack.getUUID().toString() + " to " + player.getUsername() + ".", new Object[0]);
            resourcePack.setResourcePack(player.getUniqueId());
        }).delay(1L, TimeUnit.SECONDS);
        if (update && protocol <= 340) {
            long speed = this.plugin.getConfig().getLong("update-gui-speed", 1000L);
            builder.repeat(speed, TimeUnit.MILLISECONDS);
        }
        this.addToWaiting(player, Set.of(resourcePack));
        task.set(builder.schedule());
    }

    public Optional<ForcePackPlayer> getForcePackPlayer(Player player) {
        return Optional.ofNullable(this.waiting.get(player.getUniqueId()));
    }
}

