/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.velocity.listener;

import com.convallyria.forcepack.api.check.SpoofCheck;
import com.convallyria.forcepack.api.player.ForcePackPlayer;
import com.convallyria.forcepack.api.resourcepack.ResourcePack;
import com.convallyria.forcepack.api.utils.GeyserUtil;
import com.convallyria.forcepack.velocity.ForcePackVelocity;
import com.convallyria.forcepack.velocity.config.VelocityConfig;
import com.convallyria.forcepack.velocity.handler.PackHandler;
import com.convallyria.forcepack.velocity.resourcepack.VelocityResourcePack;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.PlayerResourcePackStatusEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;

public class ResourcePackListener {
    private final ForcePackVelocity plugin;

    public ResourcePackListener(ForcePackVelocity plugin) {
        this.plugin = plugin;
    }

    @Subscribe(order=PostOrder.EARLY)
    public void onPackStatus(PlayerResourcePackStatusEvent event) {
        String text;
        boolean kick;
        VelocityResourcePack vrp;
        boolean canBypass;
        ResourcePack packByServer;
        UUID id;
        Player player = event.getPlayer();
        Optional currentServer = player.getCurrentServer();
        if (currentServer.isEmpty()) {
            this.plugin.log(player.getUsername() + "'s server does not exist.", new Object[0]);
            return;
        }
        PlayerResourcePackStatusEvent.Status status = event.getStatus();
        String serverName = ((ServerConnection)currentServer.get()).getServerInfo().getName();
        ResourcePackInfo packInfo = event.getPackInfo();
        UUID uUID = id = packInfo == null ? null : packInfo.getId();
        if (id != null) {
            this.plugin.log(player.getUsername() + " sent response id '%s'", id.toString());
        }
        if (packInfo != null && packInfo.getOrigin() != ResourcePackInfo.Origin.PLUGIN_ON_PROXY || !this.plugin.getPackHandler().isWaitingFor(player, id)) {
            this.plugin.log("Resource pack with URL %s and ID %s was sent from a downstream server! This is unsupported behaviour.", packInfo == null ? "(unknown: legacy)" : packInfo.getUrl(), id);
            return;
        }
        Set packsByServer = this.plugin.getPacksByServerAndVersion(serverName, player.getProtocolVersion()).orElse(null);
        ResourcePack resourcePack = packByServer = packsByServer == null ? null : (ResourcePack)packsByServer.stream().filter(pack -> player.getProtocolVersion().getProtocol() < ProtocolVersion.MINECRAFT_1_20_3.getProtocol() || pack.getUUID().equals(id)).findFirst().orElse(null);
        if (packByServer == null) {
            this.plugin.log("%s does not have a resource pack matching %s, ignoring status %s.", serverName, id == null ? "null" : id.toString(), status.toString());
            return;
        }
        boolean geyser = this.plugin.getConfig().getBoolean("geyser") && GeyserUtil.isBedrockPlayer(player.getUniqueId());
        boolean bl = canBypass = player.hasPermission("forcepack.bypass") && this.plugin.getConfig().getBoolean("bypass-permission");
        if (canBypass || geyser) {
            this.plugin.log("Ignoring player " + player.getUsername() + " as they do not have permissions or are a geyser player.", new Object[0]);
            return;
        }
        VelocityConfig root = packByServer.getServer().contains("ForcePack-Global-Server") ? this.plugin.getConfig().getConfig("global-pack") : (packByServer instanceof VelocityResourcePack ? ((vrp = (VelocityResourcePack)packByServer).getGroup() != null ? this.plugin.getConfig().getConfig("groups").getConfig(vrp.getGroup()) : this.plugin.getConfig().getConfig("servers").getConfig(serverName)) : this.plugin.getConfig().getConfig("servers").getConfig(serverName));
        this.plugin.log(player.getUsername() + " sent status: " + String.valueOf(event.getStatus()), new Object[0]);
        if (this.tryValidateHacks(player, status, root)) {
            return;
        }
        VelocityConfig actions = root.getConfig("actions").getConfig(status.name());
        if (actions != null) {
            for (String cmd : actions.getStringList("commands")) {
                ConsoleCommandSource console = this.plugin.getServer().getConsoleCommandSource();
                this.plugin.getServer().getCommandManager().executeAsync((CommandSource)console, cmd.replace("[player]", player.getUsername()));
            }
        }
        boolean bl2 = kick = actions != null && actions.getBoolean("kick");
        if (status != PlayerResourcePackStatusEvent.Status.ACCEPTED && status != PlayerResourcePackStatusEvent.Status.DOWNLOADED && !kick) {
            this.plugin.log("Sent player '%s' plugin message downstream to '%s' for status '%s'", player.getUsername(), ((ServerConnection)currentServer.get()).getServerInfo().getName(), status.name());
            this.plugin.getPackHandler().processWaitingResourcePack(player, packByServer.getUUID());
            String name = status == PlayerResourcePackStatusEvent.Status.SUCCESSFUL ? "SUCCESSFULLY_LOADED" : status.name();
            boolean waiting = this.plugin.getPackHandler().isWaiting(player);
            ((ServerConnection)currentServer.get()).sendPluginMessage((ChannelIdentifier)PackHandler.FORCEPACK_STATUS_IDENTIFIER, (packByServer.getUUID().toString() + ";" + name + ";" + !waiting).getBytes(StandardCharsets.UTF_8));
            this.plugin.getPackHandler().getForcePackPlayer(player).ifPresentOrElse(forcePackPlayer -> this.plugin.log("Current packs we are waiting for: %s", forcePackPlayer.getWaitingPacks()), () -> this.plugin.log("Waiting for? %s", waiting));
        }
        String string = text = actions == null ? null : actions.getString("message");
        if (text == null) {
            return;
        }
        Component component = this.plugin.getMiniMessage().deserialize((Object)text);
        if (kick) {
            player.disconnect(component);
        } else {
            player.sendMessage(component);
        }
    }

    private boolean tryValidateHacks(Player player, PlayerResourcePackStatusEvent.Status status, VelocityConfig root) {
        boolean tryPrevent = this.plugin.getConfig().getBoolean("try-to-stop-fake-accept-hacks", true);
        if (!tryPrevent) {
            return false;
        }
        ForcePackPlayer forcePackPlayer = this.plugin.getPackHandler().getForcePackPlayer(player).orElse(null);
        if (forcePackPlayer == null) {
            this.plugin.log("Not checking " + player.getUsername() + " because they are not in waiting.", new Object[0]);
            return false;
        }
        boolean hasFailed = false;
        for (SpoofCheck check : forcePackPlayer.getChecks()) {
            SpoofCheck.CheckStatus checkStatus = check.receiveStatus(status.name(), x$0 -> this.plugin.log((String)x$0, new Object[0]));
            boolean bl = hasFailed = checkStatus == SpoofCheck.CheckStatus.FAILED;
            if (checkStatus != SpoofCheck.CheckStatus.CANCEL) continue;
            this.plugin.log("Cancelling status " + String.valueOf(status) + " as a check requested it.", new Object[0]);
            return true;
        }
        if (hasFailed) {
            this.plugin.log("Kicking player " + player.getUsername() + " because they failed a check.", new Object[0]);
            VelocityConfig actionsRoot = root.getConfig("actions");
            VelocityConfig actions = actionsRoot.getConfig("FAILED_DOWNLOAD");
            return this.disconnectAction(player, actions);
        }
        return false;
    }

    private boolean disconnectAction(Player player, VelocityConfig actions) {
        String text = actions.getString("message");
        if (text == null) {
            return true;
        }
        player.disconnect(this.plugin.getMiniMessage().deserialize((Object)text));
        return true;
    }

    @Subscribe(order=PostOrder.EARLY)
    public void onJoin(ServerPostConnectEvent event) {
        Player player = event.getPlayer();
        Optional currentServer = player.getCurrentServer();
        if (currentServer.isEmpty()) {
            return;
        }
        if (this.plugin.temporaryExemptedPlayers.remove(player.getUniqueId())) {
            this.plugin.log("Ignoring player " + player.getUsername() + " as they have a one-off exemption.", new Object[0]);
            return;
        }
        this.plugin.getPackHandler().setPack(player, (ServerConnection)currentServer.get());
    }

    @Subscribe(order=PostOrder.LATE)
    public void onQuit(DisconnectEvent event) {
        this.plugin.temporaryExemptedPlayers.remove(event.getPlayer().getUniqueId());
    }
}

