/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.velocity.resourcepack;

import com.convallyria.forcepack.api.resourcepack.ResourcePack;
import com.convallyria.forcepack.api.resourcepack.ResourcePackVersion;
import com.convallyria.forcepack.velocity.ForcePackVelocity;
import com.convallyria.forcepack.velocity.config.VelocityConfig;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class VelocityResourcePack
extends ResourcePack {
    private final ForcePackVelocity velocityPlugin;
    private final String server;
    private final @Nullable String group;

    public VelocityResourcePack(ForcePackVelocity plugin, String server, String url, String hash, int size, @Nullable String group, @Nullable ResourcePackVersion version) {
        super(plugin, server, url, hash, size, version);
        this.velocityPlugin = plugin;
        this.server = server;
        this.group = group;
    }

    public @Nullable String getGroup() {
        return this.group;
    }

    @Override
    public void setResourcePack(UUID uuid) {
        int delay = this.velocityPlugin.getConfig().getInt("delay-pack-sending-by");
        if (delay > 0) {
            this.velocityPlugin.getScheduler().executeDelayed(() -> this.runSetResourcePack(uuid), delay);
        } else {
            this.runSetResourcePack(uuid);
        }
    }

    private void runSetResourcePack(UUID uuid) {
        VelocityConfig serverConfig;
        Player player = this.velocityPlugin.getServer().getPlayer(uuid).orElse(null);
        if (player == null) {
            return;
        }
        ResourcePackInfo.Builder infoBuilder = this.velocityPlugin.getServer().createResourcePackBuilder(this.getURL()).setHash(this.getHashSum()).setId(this.uuid).setShouldForce(this.velocityPlugin.getConfig().getBoolean("use-new-force-pack-screen", true));
        if (this.server.contains("ForcePack-Global-Server")) {
            serverConfig = this.velocityPlugin.getConfig().getConfig("global-pack");
            List<String> excluded = serverConfig.getStringList("exclude");
            Optional currentServer = player.getCurrentServer();
            if (currentServer.isPresent()) {
                if (excluded.contains(((ServerConnection)currentServer.get()).getServerInfo().getName())) {
                    return;
                }
            } else {
                this.velocityPlugin.log("Unable to check global resource pack exclusion list as player is not in a server!?", new Object[0]);
            }
        } else {
            serverConfig = this.velocityPlugin.getConfig().getConfig("servers").getConfig(this.server);
        }
        if (serverConfig != null) {
            String promptText = serverConfig.getConfig("resourcepack").getString("prompt");
            Component promptComponent = this.velocityPlugin.getMiniMessage().deserialize((Object)promptText);
            infoBuilder.setPrompt(promptComponent);
        }
        ResourcePackInfo built = infoBuilder.build();
        player.sendResourcePackOffer(built);
        if (this.group != null) {
            this.velocityPlugin.log("Sending resource pack %s to %s", this.group, player.getUsername());
        } else {
            this.velocityPlugin.log("Sending resource pack to %s", player.getUsername());
        }
    }
}

