/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload.relocation;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Relocation {
    private final String pattern;
    private final String shadedPattern;
    private final Set<String> includes;
    private final Set<String> excludes;

    public Relocation(@NotNull String pattern, @NotNull String shadedPattern, @Nullable Set<String> includes, @Nullable Set<String> excludes) {
        this.pattern = pattern;
        this.shadedPattern = shadedPattern;
        this.includes = includes != null ? includes : Collections.emptySet();
        this.excludes = excludes != null ? excludes : Collections.emptySet();
    }

    @NotNull
    public String getPattern() {
        return this.pattern;
    }

    @NotNull
    public String getShadedPattern() {
        return this.shadedPattern;
    }

    @NotNull
    public Set<String> getIncludes() {
        return this.includes;
    }

    @NotNull
    public Set<String> getExcludes() {
        return this.excludes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Relocation that = (Relocation)o;
        return Objects.equals(this.pattern, that.pattern) && Objects.equals(this.shadedPattern, that.shadedPattern) && Objects.equals(this.includes, that.includes) && Objects.equals(this.excludes, that.excludes);
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.shadedPattern, this.includes, this.excludes);
    }
}

