/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.paper.cloud.injection;

import forcepack.libs.geantyref.GenericTypeReflector;
import forcepack.libs.geantyref.TypeToken;
import forcepack.libs.paper.cloud.context.CommandContext;
import forcepack.libs.paper.cloud.injection.InjectionRequestImpl;
import forcepack.libs.paper.cloud.util.annotation.AnnotationAccessor;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.immutables.value.Value;

@API(status=API.Status.STABLE)
@Value.Immutable
public interface InjectionRequest<C> {
    public static <C> @NonNull InjectionRequest<C> of(@NonNull CommandContext<C> context, @NonNull TypeToken<?> injectedType, @NonNull AnnotationAccessor annotationAccessor) {
        return InjectionRequestImpl.of(context, injectedType, annotationAccessor);
    }

    public static <C> @NonNull InjectionRequest<C> of(@NonNull CommandContext<C> context, @NonNull TypeToken<?> injectedType) {
        return InjectionRequestImpl.of(context, injectedType, AnnotationAccessor.empty());
    }

    public @NonNull CommandContext<C> commandContext();

    public @NonNull TypeToken<?> injectedType();

    @Value.Derived
    default public @NonNull Class<?> injectedClass() {
        return GenericTypeReflector.erase(this.injectedType().getType());
    }

    public @NonNull AnnotationAccessor annotationAccessor();
}

