/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.paper.cloud.services;

import forcepack.libs.geantyref.TypeToken;
import forcepack.libs.paper.cloud.services.PipelineException;
import forcepack.libs.paper.cloud.services.ServiceRepository;
import forcepack.libs.paper.cloud.services.type.Service;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;

enum ServiceFilterHandler {
    INSTANCE;


    <Context> boolean passes(@NonNull ServiceRepository.ServiceWrapper<? extends Service<Context, ?>> service, @NonNull Context context) {
        if (!service.isDefaultImplementation()) {
            for (Predicate predicate : service.filters()) {
                try {
                    if (predicate.test(context)) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new PipelineException(String.format("Failed to evaluate filter '%s' for '%s'", TypeToken.get(predicate.getClass()).getType().getTypeName(), service), e);
                }
            }
        }
        return true;
    }
}

