/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.chat;

import com.convallyria.forcepack.paper.libs.adventure.adventure.text.Component;
import com.convallyria.forcepack.paper.libs.adventure.adventure.util.Index;
import forcepack.libs.pe.api.protocol.chat.ChatTypeDecoration;
import forcepack.libs.pe.api.protocol.chat.StaticChatType;
import forcepack.libs.pe.api.protocol.chat.message.ChatMessage_v1_19_1;
import forcepack.libs.pe.api.protocol.mapper.CopyableEntity;
import forcepack.libs.pe.api.protocol.mapper.DeepComparableEntity;
import forcepack.libs.pe.api.protocol.mapper.MappedEntity;
import forcepack.libs.pe.api.protocol.nbt.NBT;
import forcepack.libs.pe.api.protocol.nbt.NBTCompound;
import forcepack.libs.pe.api.protocol.nbt.NBTString;
import forcepack.libs.pe.api.protocol.player.ClientVersion;
import forcepack.libs.pe.api.util.adventure.AdventureIndexUtil;
import forcepack.libs.pe.api.util.mappings.TypesBuilderData;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public interface ChatType
extends MappedEntity,
CopyableEntity<ChatType>,
DeepComparableEntity {
    public @UnknownNullability(value="only nullable for 1.19") ChatTypeDecoration getChatDecoration();

    @ApiStatus.Obsolete(since="1.19.1")
    @Nullable
    public ChatTypeDecoration getOverlayDecoration();

    public @UnknownNullability(value="only nullable for 1.19") ChatTypeDecoration getNarrationDecoration();

    @ApiStatus.Obsolete(since="1.19.1")
    @Nullable
    public NarrationPriority getNarrationPriority();

    public static ChatType readDirect(PacketWrapper<?> wrapper) {
        ChatTypeDecoration chatDecoration = ChatTypeDecoration.read(wrapper);
        ChatTypeDecoration narrationDecoration = ChatTypeDecoration.read(wrapper);
        return new StaticChatType(chatDecoration, narrationDecoration);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, ChatType chatType) {
        ChatTypeDecoration.write(wrapper, chatType.getChatDecoration());
        ChatTypeDecoration.write(wrapper, chatType.getNarrationDecoration());
    }

    public static ChatType decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        NBTCompound chatTag = compound.getCompoundTagOrNull("chat");
        NBTCompound narrationTag = compound.getCompoundTagOrNull("narration");
        ChatTypeDecoration overlay = null;
        NarrationPriority narrationPriority = null;
        if (version.isOlderThan(ClientVersion.V_1_19_1)) {
            NBTCompound overlayTag = compound.getCompoundTagOrNull("overlay");
            if (overlayTag != null && (overlayTag = overlayTag.getCompoundTagOrNull("description")) != null) {
                overlay = ChatTypeDecoration.decode((NBT)overlayTag, version);
            }
            if (chatTag != null) {
                chatTag = chatTag.getCompoundTagOrNull("description");
            }
            if (narrationTag != null) {
                narrationPriority = AdventureIndexUtil.indexValueOrThrow(NarrationPriority.ID_INDEX, narrationTag.getStringTagValueOrThrow("priority"));
                narrationTag = narrationTag.getCompoundTagOrNull("description");
            }
        } else {
            Objects.requireNonNull(chatTag, "NBT chat does not exist");
            Objects.requireNonNull(narrationTag, "NBT narration does not exist");
        }
        ChatTypeDecoration chat = chatTag == null ? null : ChatTypeDecoration.decode((NBT)chatTag, version);
        ChatTypeDecoration narration = narrationTag == null ? null : ChatTypeDecoration.decode((NBT)narrationTag, version);
        return new StaticChatType(data, chat, overlay, narration, narrationPriority);
    }

    public static NBT encode(ChatType chatType, ClientVersion version) {
        NBT narrationTag;
        NBTCompound compound = new NBTCompound();
        NBT chatTag = chatType.getChatDecoration() == null ? null : ChatTypeDecoration.encode(chatType.getChatDecoration(), version);
        NBT nBT = narrationTag = chatType.getNarrationDecoration() == null ? null : ChatTypeDecoration.encode(chatType.getNarrationDecoration(), version);
        if (version.isOlderThan(ClientVersion.V_1_19_1)) {
            ChatTypeDecoration overlayDeco = chatType.getOverlayDecoration();
            if (overlayDeco != null) {
                NBTCompound overlayCompound = new NBTCompound();
                overlayCompound.setTag("description", ChatTypeDecoration.encode(overlayDeco, version));
                compound.setTag("overlay", overlayCompound);
            }
            if (narrationTag != null) {
                NBTCompound narrationCompound = new NBTCompound();
                narrationCompound.setTag("description", narrationTag);
                if (chatType.getNarrationPriority() != null) {
                    narrationCompound.setTag("priority", new NBTString(chatType.getNarrationPriority().getId()));
                }
                narrationTag = narrationCompound;
            }
            if (chatTag != null) {
                NBTCompound chatCompound = new NBTCompound();
                chatCompound.setTag("description", chatTag);
                chatTag = chatCompound;
            }
        }
        if (chatTag != null) {
            compound.setTag("chat", chatTag);
        }
        if (narrationTag != null) {
            compound.setTag("narration", narrationTag);
        }
        return compound;
    }

    @ApiStatus.Obsolete(since="1.19.1")
    public static enum NarrationPriority {
        CHAT("chat"),
        SYSTEM("system");

        public static final Index<String, NarrationPriority> ID_INDEX;
        private final String id;

        private NarrationPriority(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        static {
            ID_INDEX = Index.create(NarrationPriority.class, NarrationPriority::getId);
        }
    }

    public static class Bound
    extends ChatMessage_v1_19_1.ChatTypeBoundNetwork {
        public Bound(ChatType type, Component name, @Nullable Component targetName) {
            super(type, name, targetName);
        }
    }
}

