/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.chat.clickevent;

import forcepack.libs.pe.api.manager.server.ServerVersion;
import forcepack.libs.pe.api.protocol.chat.clickevent.ClickEvent;
import forcepack.libs.pe.api.protocol.chat.clickevent.ClickEventAction;
import forcepack.libs.pe.api.protocol.chat.clickevent.ClickEventActions;
import forcepack.libs.pe.api.protocol.nbt.NBTCompound;
import forcepack.libs.pe.api.protocol.nbt.NBTString;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RunCommandClickEvent
implements ClickEvent {
    private final String command;

    public RunCommandClickEvent(String command) {
        this.command = command;
    }

    public static RunCommandClickEvent decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        boolean v1215 = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5);
        String command = compound.getStringTagValueOrThrow(v1215 ? "command" : "value");
        return new RunCommandClickEvent(command);
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, RunCommandClickEvent clickEvent) {
        boolean v1215 = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5);
        compound.setTag(v1215 ? "command" : "value", new NBTString(clickEvent.command));
    }

    @Override
    public ClickEventAction<?> getAction() {
        return ClickEventActions.RUN_COMMAND;
    }

    @Override
    public com.convallyria.forcepack.paper.libs.adventure.adventure.text.event.ClickEvent asAdventure() {
        return com.convallyria.forcepack.paper.libs.adventure.adventure.text.event.ClickEvent.runCommand(this.command);
    }

    public String getCommand() {
        return this.command;
    }
}

