/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.component.builtin.item;

import forcepack.libs.pe.api.manager.server.ServerVersion;
import forcepack.libs.pe.api.protocol.item.instrument.Instrument;
import forcepack.libs.pe.api.protocol.item.instrument.Instruments;
import forcepack.libs.pe.api.protocol.mapper.MaybeMappedEntity;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import java.util.Objects;

public class ItemInstrument {
    private MaybeMappedEntity<Instrument> instrument;

    public ItemInstrument(MaybeMappedEntity<Instrument> instrument) {
        this.instrument = instrument;
    }

    public static ItemInstrument read(PacketWrapper<?> wrapper) {
        MaybeMappedEntity<Instrument> instrument = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5) ? MaybeMappedEntity.read(wrapper, Instruments.getRegistry(), Instrument::read) : new MaybeMappedEntity<Instrument>(Instrument.read(wrapper));
        return new ItemInstrument(instrument);
    }

    public static void write(PacketWrapper<?> wrapper, ItemInstrument instrument) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5)) {
            MaybeMappedEntity.write(wrapper, instrument.instrument, Instrument::write);
        } else {
            Instrument.write(wrapper, instrument.instrument.getValueOrThrow());
        }
    }

    public MaybeMappedEntity<Instrument> getInstrument() {
        return this.instrument;
    }

    public void setInstrument(MaybeMappedEntity<Instrument> instrument) {
        this.instrument = instrument;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemInstrument)) {
            return false;
        }
        ItemInstrument that = (ItemInstrument)obj;
        return this.instrument.equals(that.instrument);
    }

    public int hashCode() {
        return Objects.hashCode(this.instrument);
    }
}

