/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.dialog;

import com.convallyria.forcepack.paper.libs.adventure.adventure.dialog.DialogLike;
import forcepack.libs.pe.api.protocol.dialog.DialogType;
import forcepack.libs.pe.api.protocol.dialog.DialogTypes;
import forcepack.libs.pe.api.protocol.dialog.Dialogs;
import forcepack.libs.pe.api.protocol.mapper.CopyableEntity;
import forcepack.libs.pe.api.protocol.mapper.DeepComparableEntity;
import forcepack.libs.pe.api.protocol.mapper.MappedEntity;
import forcepack.libs.pe.api.protocol.nbt.NBT;
import forcepack.libs.pe.api.protocol.nbt.NBTCompound;
import forcepack.libs.pe.api.protocol.nbt.NBTString;
import forcepack.libs.pe.api.util.mappings.TypesBuilderData;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface Dialog
extends MappedEntity,
DeepComparableEntity,
CopyableEntity<Dialog>,
DialogLike {
    public static Dialog read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(Dialogs.getRegistry(), Dialog::readDirect);
    }

    public static void write(PacketWrapper<?> wrapper, Dialog dialog) {
        wrapper.writeMappedEntityOrDirect(dialog, Dialog::writeDirect);
    }

    public static Dialog readDirect(PacketWrapper<?> wrapper) {
        return Dialog.decodeDirect(wrapper.readNBTRaw(), wrapper, null);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, Dialog dialog) {
        wrapper.writeNBTRaw(Dialog.encodeDirect(dialog, wrapper));
    }

    public static Dialog decode(NBT nbt, PacketWrapper<?> wrapper) {
        if (nbt instanceof NBTString) {
            return wrapper.replaceRegistry(Dialogs.getRegistry()).getByNameOrThrow(((NBTString)nbt).getValue());
        }
        return Dialog.decodeDirect(nbt, wrapper, null);
    }

    public static NBT encode(PacketWrapper<?> wrapper, Dialog dialog) {
        if (dialog.isRegistered()) {
            return new NBTString(dialog.getName().toString());
        }
        return Dialog.encodeDirect(dialog, wrapper);
    }

    @ApiStatus.Internal
    public static Dialog decodeDirect(NBT nbt, PacketWrapper<?> wrapper, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        String dialogTypeName = compound.getStringTagValueOrThrow("type");
        DialogType dialogType = (DialogType)DialogTypes.getRegistry().getByNameOrThrow(dialogTypeName);
        return (Dialog)dialogType.decode(compound, wrapper).copy(data);
    }

    @ApiStatus.Internal
    public static NBT encodeDirect(Dialog dialog, PacketWrapper<?> wrapper) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("type", new NBTString(dialog.getType().getName().toString()));
        dialog.getType().encode(compound, wrapper, dialog);
        return compound;
    }

    public DialogType<?> getType();
}

