/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.dialog;

import com.convallyria.forcepack.paper.libs.adventure.adventure.util.Index;
import forcepack.libs.pe.api.protocol.nbt.NBT;
import forcepack.libs.pe.api.protocol.nbt.NBTString;
import forcepack.libs.pe.api.util.adventure.AdventureIndexUtil;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public enum DialogAction {
    CLOSE("close", true),
    NONE("none", false),
    WAIT_FOR_RESPONSE("wait_for_response", true);

    public static final Index<String, DialogAction> NAME_INDEX;
    private final String name;
    private final boolean willUnpause;

    private DialogAction(String name, boolean willUnpause) {
        this.name = name;
        this.willUnpause = willUnpause;
    }

    public static DialogAction decode(NBT nbt, PacketWrapper<?> wrapper) {
        return AdventureIndexUtil.indexValueOrThrow(NAME_INDEX, ((NBTString)nbt).getValue());
    }

    public static NBT encode(PacketWrapper<?> wrapper, DialogAction action) {
        return new NBTString(action.name);
    }

    public String getName() {
        return this.name;
    }

    public boolean isWillUnpause() {
        return this.willUnpause;
    }

    static {
        NAME_INDEX = Index.create(DialogAction.class, DialogAction::getName);
    }
}

