/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.world.biome;

import forcepack.libs.pe.api.protocol.mapper.AbstractMappedEntity;
import forcepack.libs.pe.api.protocol.world.biome.Biome;
import forcepack.libs.pe.api.protocol.world.biome.BiomeEffects;
import forcepack.libs.pe.api.util.mappings.TypesBuilderData;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class StaticBiome
extends AbstractMappedEntity
implements Biome {
    private final boolean precipitation;
    private final float temperature;
    private final Biome.TemperatureModifier temperatureModifier;
    private final float downfall;
    @Nullable
    private final Biome.Category category;
    @Nullable
    private final Float depth;
    @Nullable
    private final Float scale;
    private final BiomeEffects effects;

    public StaticBiome(boolean precipitation, float temperature, Biome.TemperatureModifier temperatureModifier, float downfall, BiomeEffects effects) {
        this(null, precipitation, temperature, temperatureModifier, downfall, effects);
    }

    @ApiStatus.Internal
    @ApiStatus.Obsolete
    public StaticBiome(@Nullable TypesBuilderData data, Biome.Precipitation precipitation, float temperature, Biome.TemperatureModifier temperatureModifier, float downfall, BiomeEffects effects) {
        this(data, precipitation != Biome.Precipitation.NONE, temperature, temperatureModifier, downfall, effects);
    }

    @ApiStatus.Internal
    public StaticBiome(@Nullable TypesBuilderData data, boolean precipitation, float temperature, Biome.TemperatureModifier temperatureModifier, float downfall, BiomeEffects effects) {
        this(data, precipitation, temperature, temperatureModifier, downfall, null, null, null, effects);
    }

    public StaticBiome(boolean precipitation, float temperature, Biome.TemperatureModifier temperatureModifier, float downfall, @Nullable Biome.Category category, @Nullable Float depth, @Nullable Float scale, BiomeEffects effects) {
        this(null, precipitation, temperature, temperatureModifier, downfall, category, depth, scale, effects);
    }

    @ApiStatus.Internal
    @ApiStatus.Obsolete
    public StaticBiome(@Nullable TypesBuilderData data, Biome.Precipitation precipitation, float temperature, Biome.TemperatureModifier temperatureModifier, float downfall, @Nullable Biome.Category category, @Nullable Float depth, @Nullable Float scale, BiomeEffects effects) {
        this(data, precipitation != Biome.Precipitation.NONE, temperature, temperatureModifier, downfall, category, depth, scale, effects);
    }

    @ApiStatus.Internal
    public StaticBiome(@Nullable TypesBuilderData data, boolean precipitation, float temperature, Biome.TemperatureModifier temperatureModifier, float downfall, @Nullable Biome.Category category, @Nullable Float depth, @Nullable Float scale, BiomeEffects effects) {
        super(data);
        this.precipitation = precipitation;
        this.temperature = temperature;
        this.temperatureModifier = temperatureModifier;
        this.downfall = downfall;
        this.category = category;
        this.depth = depth;
        this.scale = scale;
        this.effects = effects;
    }

    @Override
    public Biome copy(@Nullable TypesBuilderData newData) {
        return new StaticBiome(newData, this.precipitation, this.temperature, this.temperatureModifier, this.downfall, this.category, this.depth, this.scale, this.effects);
    }

    @Override
    public boolean hasPrecipitation() {
        return this.precipitation;
    }

    @Override
    public Biome.Precipitation getPrecipitation() {
        if (!this.hasPrecipitation()) {
            return Biome.Precipitation.NONE;
        }
        switch (this.getTemperatureModifier()) {
            case NONE: {
                return Biome.Precipitation.RAIN;
            }
            case FROZEN: {
                return Biome.Precipitation.SNOW;
            }
        }
        throw new AssertionError();
    }

    @Override
    public float getTemperature() {
        return this.temperature;
    }

    @Override
    public Biome.TemperatureModifier getTemperatureModifier() {
        return this.temperatureModifier;
    }

    @Override
    public float getDownfall() {
        return this.downfall;
    }

    @Override
    @Nullable
    public Biome.Category getCategory() {
        return this.category;
    }

    @Override
    @Nullable
    public Float getDepth() {
        return this.depth;
    }

    @Override
    @Nullable
    public Float getScale() {
        return this.scale;
    }

    @Override
    public BiomeEffects getEffects() {
        return this.effects;
    }

    @Override
    public boolean deepEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticBiome)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StaticBiome that = (StaticBiome)obj;
        if (this.precipitation != that.precipitation) {
            return false;
        }
        if (Float.compare(that.temperature, this.temperature) != 0) {
            return false;
        }
        if (Float.compare(that.downfall, this.downfall) != 0) {
            return false;
        }
        if (this.temperatureModifier != that.temperatureModifier) {
            return false;
        }
        if (this.category != that.category) {
            return false;
        }
        if (!Objects.equals(this.depth, that.depth)) {
            return false;
        }
        if (!Objects.equals(this.scale, that.scale)) {
            return false;
        }
        return this.effects.equals(that.effects);
    }

    @Override
    public int deepHashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.precipitation, Float.valueOf(this.temperature), this.temperatureModifier, Float.valueOf(this.downfall), this.category, this.depth, this.scale, this.effects});
    }

    @Override
    public String toString() {
        return "StaticBiome{precipitation=" + this.precipitation + ", temperature=" + this.temperature + ", temperatureModifier=" + (Object)((Object)this.temperatureModifier) + ", downfall=" + this.downfall + ", category=" + (Object)((Object)this.category) + ", depth=" + this.depth + ", scale=" + this.scale + ", effects=" + this.effects + '}';
    }
}

