/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.wrapper.play.server;

import forcepack.libs.pe.api.event.PacketSendEvent;
import forcepack.libs.pe.api.protocol.packettype.PacketType;
import forcepack.libs.pe.api.wrapper.PacketWrapper;

public class WrapperPlayServerEntityAnimation
extends PacketWrapper<WrapperPlayServerEntityAnimation> {
    private int entityID;
    private EntityAnimationType type;

    public WrapperPlayServerEntityAnimation(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerEntityAnimation(int entityID, EntityAnimationType type) {
        super(PacketType.Play.Server.ENTITY_ANIMATION);
        this.entityID = entityID;
        this.type = type;
    }

    @Override
    public void read() {
        this.entityID = this.readVarInt();
        this.type = EntityAnimationType.getById(this.readUnsignedByte());
    }

    @Override
    public void write() {
        this.writeVarInt(this.entityID);
        this.writeByte(this.type.ordinal());
    }

    @Override
    public void copy(WrapperPlayServerEntityAnimation wrapper) {
        this.entityID = wrapper.entityID;
        this.type = wrapper.type;
    }

    public int getEntityId() {
        return this.entityID;
    }

    public void setEntityId(int entityID) {
        this.entityID = entityID;
    }

    public EntityAnimationType getType() {
        return this.type;
    }

    public void setType(EntityAnimationType type) {
        this.type = type;
    }

    public static enum EntityAnimationType {
        SWING_MAIN_ARM,
        HURT,
        WAKE_UP,
        SWING_OFF_HAND,
        CRITICAL_HIT,
        MAGIC_CRITICAL_HIT;

        private static final EntityAnimationType[] VALUES;

        public static EntityAnimationType getById(int id) {
            return VALUES[id];
        }

        static {
            VALUES = EntityAnimationType.values();
        }
    }
}

