/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.api.set.crystal;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.xelbayria.gems_realm.GemsRealm;
import net.xelbayria.gems_realm.api.set.RockType;
import net.xelbayria.gems_realm.api.set.crystal.CrystalTypeRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class CrystalType
extends RockType {
    protected CrystalType(class_2960 id, class_2248 blockCrystal) {
        super(id, blockCrystal);
    }

    public String getTranslationKey() {
        return "crystal_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    protected void initializeChildrenBlocks() {
        this.addChild("cluster", this.findRelatedBlock("", "cluster"));
        this.addChild("glinted_cluster", this.findRelatedBlock("glinted", "cluster"));
        this.addChild("lamp", this.findRelatedBlock("", "lamp"));
        this.addChild("budding", this.findRelatedBlock("budding", ""));
        super.initializeChildrenBlocks();
    }

    @Override
    protected void initializeChildrenItems() {
        this.addChild("shard", this.findRelatedItem("", "shard"));
    }

    @Override
    protected class_2248 findRelatedBlock(String prefixOrInfix, String suffix) {
        return (class_2248)this.findRelatedEntry(prefixOrInfix, suffix, (class_2378)class_7923.field_41175);
    }

    @Override
    protected class_1792 findRelatedItem(String prefixOrInfix, String suffix) {
        return (class_1792)this.findRelatedEntry(prefixOrInfix, suffix, (class_2378)class_7923.field_41178);
    }

    @Override
    @Nullable
    protected <V> V findRelatedEntry(String prefixOrInfix, String suffix, class_2378<V> reg) {
        V block = super.findRelatedEntry(prefixOrInfix, suffix, reg);
        if (Objects.nonNull(block)) {
            return block;
        }
        Object prefix_ = prefixOrInfix.isEmpty() ? "" : prefixOrInfix + "_";
        Object _infix = prefixOrInfix.isEmpty() ? "" : "_" + prefixOrInfix;
        Object _suffix = suffix.isEmpty() ? "" : "_" + suffix;
        class_2960[] targets = new class_2960[]{new class_2960(this.id.method_12836(), this.id.method_12832() + (String)_infix + (String)_suffix), new class_2960(this.id.method_12836(), (String)prefix_ + this.id.method_12832() + (String)_suffix)};
        Object found = null;
        for (class_2960 r : targets) {
            if (!reg.method_10250(r)) continue;
            found = reg.method_10223(r);
            break;
        }
        return (V)found;
    }

    public static class_2248 findCrystalBlock(class_2960 id) {
        class_2960[] tests = CrystalType.makeKnownIDConventions(id, "block");
        return (class_2248)Utils.findFirstInRegistry((class_2378)class_7923.field_41175, (class_2960[])tests);
    }

    public static class Finder
    extends BlockType.SetFinderBuilder<CrystalType> {
        private Supplier<class_2248> blockCrystalFinder;

        public Finder(class_2960 id) {
            super(id, (BlockTypeRegistry)CrystalTypeRegistry.INSTANCE);
            this.crystalBlock(() -> CrystalType.findCrystalBlock(id));
        }

        public Finder crystalBlock(Supplier<class_2248> crystalFinder) {
            this.blockCrystalFinder = crystalFinder;
            return this;
        }

        public Finder crystalBlock(class_2960 id) {
            return this.crystalBlock(() -> (class_2248)class_7923.field_41175.method_17966(id).orElseThrow(() -> new IllegalStateException("Failed to find Crystal Block: " + String.valueOf(id))));
        }

        public Finder crystalBlock(String nameCrystalBlock) {
            return this.crystalBlock(Utils.idWithOptionalNamespace((String)nameCrystalBlock, (String)this.id.method_12836()));
        }

        public Finder crystalBlockAffix(String prefix, String suffix) {
            return this.crystalBlock(prefix + this.id.method_12832() + suffix);
        }

        public Finder crystalBlockSuffix(String suffix) {
            return this.crystalBlock(this.id.method_12832() + suffix);
        }

        @ApiStatus.Internal
        public Optional<CrystalType> get() {
            if (PlatHelper.isModLoaded((String)this.id.method_12836())) {
                try {
                    class_2248 crystal = (class_2248)Preconditions.checkNotNull((Object)this.blockCrystalFinder.get(), (String)"Manual Finder - failed to find a Crystal Block for {}", (Object)this.id);
                    CrystalType crystalType = new CrystalType(this.id, crystal);
                    this.childNames.forEach((key, value) -> {
                        try {
                            class_1935 obj = (class_1935)Preconditions.checkNotNull((Object)((class_1935)value.get()));
                            crystalType.addChild((String)key, obj);
                        }
                        catch (Exception e) {
                            GemsRealm.LOGGER.warn("Failed to get children for CrystalType: {} - {}. Ignored! ERROR: {}", (Object)this.id, key, (Object)e.getMessage());
                        }
                    });
                    return Optional.of(crystalType);
                }
                catch (Exception e) {
                    GemsRealm.LOGGER.warn("Failed to find custom CrystalType: {} - ", (Object)this.id, (Object)e);
                }
            }
            return Optional.empty();
        }
    }
}

