/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.api.set.dust;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.xelbayria.gems_realm.GemsRealm;
import net.xelbayria.gems_realm.api.set.RockType;
import net.xelbayria.gems_realm.api.set.dust.DustTypeRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DustType
extends RockType {
    protected DustType(class_2960 id, class_2248 blockDust) {
        super(id, blockDust);
    }

    public String getTranslationKey() {
        return "dust_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    protected void initializeChildrenBlocks() {
        super.initializeChildrenBlocks();
    }

    @Override
    protected void initializeChildrenItems() {
        this.addChild("dust", this.findRelatedItem("", "dust"));
    }

    @Override
    @Nullable
    protected <V> V findRelatedEntry(String prefixOrInfix, String suffix, class_2378<V> reg) {
        V block = super.findRelatedEntry(prefixOrInfix, suffix, reg);
        if (Objects.nonNull(block)) {
            return block;
        }
        Object prefix_ = prefixOrInfix.isEmpty() ? "" : prefixOrInfix + "_";
        Object _infix = prefixOrInfix.isEmpty() ? "" : "_" + prefixOrInfix;
        Object _suffix = suffix.isEmpty() ? "" : "_" + suffix;
        class_2960[] targets = new class_2960[]{new class_2960(this.id.method_12836(), this.id.method_12832() + (String)_infix + (String)_suffix), new class_2960(this.id.method_12836(), (String)prefix_ + this.id.method_12832() + (String)_suffix)};
        Object found = null;
        for (class_2960 r : targets) {
            if (!reg.method_10250(r)) continue;
            found = reg.method_10223(r);
            break;
        }
        return (V)found;
    }

    public static class_2248 findDustBlock(class_2960 id) {
        class_2960[] tests = DustType.makeKnownIDConventions(id, "dust");
        return (class_2248)Utils.findFirstInRegistry((class_2378)class_7923.field_41175, (class_2960[])tests);
    }

    public static class Finder
    extends BlockType.SetFinderBuilder<DustType> {
        private Supplier<class_2248> blockDustFinder;

        public Finder(class_2960 id) {
            super(id, (BlockTypeRegistry)DustTypeRegistry.INSTANCE);
            this.dustBlock(() -> DustType.findDustBlock(id));
        }

        public Finder dustBlock(Supplier<class_2248> dustFinder) {
            this.blockDustFinder = dustFinder;
            return this;
        }

        public Finder dustBlock(class_2960 id) {
            return this.dustBlock(() -> (class_2248)class_7923.field_41175.method_17966(id).orElseThrow(() -> new IllegalStateException("Failed to find Dust Block: " + String.valueOf(id))));
        }

        public Finder dustBlock(String nameDustBlock) {
            return this.dustBlock(Utils.idWithOptionalNamespace((String)nameDustBlock, (String)this.id.method_12836()));
        }

        public Finder dustBlockAffix(String prefix, String suffix) {
            return this.dustBlock(prefix + this.id.method_12832() + suffix);
        }

        public Finder dustBlockSuffix(String suffix) {
            return this.dustBlock(this.id.method_12832() + suffix);
        }

        @ApiStatus.Internal
        public Optional<DustType> get() {
            if (PlatHelper.isModLoaded((String)this.id.method_12836())) {
                try {
                    class_2248 dust = (class_2248)Preconditions.checkNotNull((Object)this.blockDustFinder.get(), (String)"Manual Finder - failed to find a Dust Block for {}", (Object)this.id);
                    DustType dustType = new DustType(this.id, dust);
                    this.childNames.forEach((key, value) -> {
                        try {
                            class_1935 obj = (class_1935)Preconditions.checkNotNull((Object)((class_1935)value.get()));
                            dustType.addChild((String)key, obj);
                        }
                        catch (Exception e) {
                            GemsRealm.LOGGER.warn("Failed to get children for DustType: {} - {}. Ignored! ERROR: {}", (Object)this.id, key, (Object)e.getMessage());
                        }
                    });
                    return Optional.of(dustType);
                }
                catch (Exception e) {
                    GemsRealm.LOGGER.warn("Failed to find custom DustType: {} - ", (Object)this.id, (Object)e);
                }
            }
            return Optional.empty();
        }
    }
}

