/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.api.set.dust;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.xelbayria.gems_realm.api.set.dust.DustType;
import net.xelbayria.gems_realm.api.set.dust.VanillaDustTypes;
import net.xelbayria.gems_realm.misc.HardcodedBlockType;

public class DustTypeRegistry
extends BlockTypeRegistry<DustType> {
    public static final DustTypeRegistry INSTANCE = new DustTypeRegistry();

    public DustTypeRegistry() {
        super(DustType.class, "dust_type");
    }

    public DustType register(DustType vanillaType) {
        return (DustType)super.register((BlockType)vanillaType);
    }

    public DustType getDefaultType() {
        return VanillaDustTypes.REDSTONE;
    }

    public Optional<DustType> detectTypeFromBlock(class_2248 baseBlock, class_2960 baseRes) {
        String blockPath = baseRes.method_12832();
        if (blockPath.matches("\\w+_block")) {
            Optional opt;
            boolean noGemType;
            String crystalName = blockPath.replace("_block", "");
            class_2960 idBlockType = baseRes.method_45136(crystalName);
            boolean hasDust = class_7923.field_41178.method_10250(new class_2960(baseRes.method_12836(), blockPath.replace("block", "dust")));
            boolean noWoodType = !class_7923.field_41178.method_10250(new class_2960(baseRes.method_12836(), blockPath.replace("block", "log")));
            boolean noMetalType = !class_7923.field_41178.method_10250(new class_2960(baseRes.method_12836(), blockPath.replace("block", "ingot")));
            boolean bl = noGemType = !class_7923.field_41178.method_10250(new class_2960(baseRes.method_12836(), blockPath.replace("_block", "")));
            if (!this.valuesReg.containsKey(idBlockType) && hasDust && noWoodType && noMetalType && noGemType && !HardcodedBlockType.BLACKLISTED_DUSTTYPES.contains(idBlockType.toString()) && !HardcodedBlockType.BLACKLISTED_MODS.contains(baseRes.method_12836()) && !HardcodedBlockType.BLACKLISTED_DUST_MODS.contains(baseRes.method_12836()) && (opt = class_7923.field_41175.method_17966(baseRes)).isPresent()) {
                return Optional.of(new DustType(idBlockType, (class_2248)opt.get()));
            }
        }
        return Optional.empty();
    }

    public DustType.Finder addSimpleFinder(class_2960 dustTypeId) {
        DustType.Finder finder = new DustType.Finder(dustTypeId);
        this.addFinder((BlockType.SetFinder)finder);
        return finder;
    }

    public DustType.Finder addSimpleFinder(String typeId) {
        return this.addSimpleFinder(new class_2960(typeId));
    }

    public DustType.Finder addSimpleFinder(String namespace, String nameDustType) {
        return this.addSimpleFinder(new class_2960(namespace, nameDustType));
    }

    public int priority() {
        return 110;
    }
}

