/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.api.set.metal;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.xelbayria.gems_realm.GemsRealm;
import net.xelbayria.gems_realm.api.set.RockType;
import net.xelbayria.gems_realm.api.set.metal.MetalTypeRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class MetalType
extends RockType {
    protected MetalType(class_2960 id, class_2248 block) {
        super(id, block);
    }

    public String getTranslationKey() {
        return "metal_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    protected void initializeChildrenBlocks() {
        super.initializeChildrenBlocks();
        this.addChild("trapdoor", this.findRelatedBlock("", "trapdoor"));
        this.addChild("lamp", this.findRelatedBlock("", "lamp"));
        this.addChild("chain", this.findRelatedBlock("", "chain"));
        this.addChild("anvil", this.findRelatedBlock("", "anvil"));
        this.addChild("bars", this.findRelatedBlock("", "bars"));
    }

    @Override
    protected void initializeChildrenItems() {
        this.addChild("ingot", this.findRelatedItem("", "ingot"));
        this.addChild("nugget", this.findRelatedItem("", "nugget"));
    }

    @Override
    @Nullable
    protected <V> V findRelatedEntry(String prefixOrInfix, String suffix, class_2378<V> reg) {
        V block = super.findRelatedEntry(prefixOrInfix, (String)suffix, reg);
        if (Objects.nonNull(block)) {
            return block;
        }
        if (this.getId().method_12836().matches("tfc|afc")) {
            Object prefix = prefixOrInfix.isEmpty() ? "" : prefixOrInfix + "_";
            String withoutUnderscore = suffix;
            if (!((String)suffix).isEmpty()) {
                suffix = "_" + (String)suffix;
            }
            class_2960[] targets = new class_2960[]{new class_2960(this.id.method_12836(), "metal/" + (String)prefix + withoutUnderscore + "/" + this.id.method_12832()), new class_2960(this.id.method_12836(), "metal/" + prefixOrInfix + "/" + this.id.method_12832() + (String)suffix)};
            Object found = null;
            for (class_2960 r : targets) {
                if (!reg.method_10250(r)) continue;
                found = reg.method_10223(r);
                break;
            }
            return (V)found;
        }
        return null;
    }

    public static class_2248 findMetalBlock(class_2960 id) {
        class_2960[] tests = MetalType.makeKnownIDConventions(id, "block");
        return (class_2248)Utils.findFirstInRegistry((class_2378)class_7923.field_41175, (class_2960[])tests);
    }

    public static class Finder
    extends BlockType.SetFinderBuilder<MetalType> {
        private Supplier<class_2248> blockMetalFinder;

        public Finder(class_2960 id) {
            super(id, (BlockTypeRegistry)MetalTypeRegistry.INSTANCE);
            this.metalBlock(() -> MetalType.findMetalBlock(id));
        }

        public Finder metalBlock(Supplier<class_2248> metalFinder) {
            this.blockMetalFinder = metalFinder;
            return this;
        }

        public Finder metalBlock(class_2960 id) {
            return this.metalBlock(() -> (class_2248)class_7923.field_41175.method_17966(id).orElseThrow(() -> new IllegalStateException("Failed to find Metal Block: " + String.valueOf(id))));
        }

        public Finder metalBlock(String nameMetalBlock) {
            return this.metalBlock(Utils.idWithOptionalNamespace((String)nameMetalBlock, (String)this.id.method_12836()));
        }

        public Finder metalBlockAffix(String prefix, String suffix) {
            return this.metalBlock(prefix + this.id.method_12832() + suffix);
        }

        public Finder metalBlockSuffix(String suffix) {
            return this.metalBlock(this.id.method_12832() + suffix);
        }

        @ApiStatus.Internal
        public Optional<MetalType> get() {
            if (PlatHelper.isModLoaded((String)this.id.method_12836())) {
                try {
                    class_2248 metal = (class_2248)Preconditions.checkNotNull((Object)this.blockMetalFinder.get(), (String)"Manual Finder - failed to find a Metal Block for {}", (Object)this.id);
                    MetalType metalType = new MetalType(this.id, metal);
                    this.childNames.forEach((key, value) -> {
                        try {
                            class_1935 obj = (class_1935)Preconditions.checkNotNull((Object)((class_1935)value.get()));
                            metalType.addChild((String)key, obj);
                        }
                        catch (Exception e) {
                            GemsRealm.LOGGER.warn("Failed to get children for MetalType: {} - {}. Ignored! ERROR: {}", (Object)this.id, key, (Object)e.getMessage());
                        }
                    });
                    return Optional.of(metalType);
                }
                catch (Exception e) {
                    GemsRealm.LOGGER.warn("Failed to find custom MetalType: {} - ", (Object)this.id, (Object)e);
                }
            }
            return Optional.empty();
        }
    }
}

