/*
 * Decompiled with CFR 0.152.
 */
package net.xelbayria.gems_realm.api.set.metal;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.xelbayria.gems_realm.api.set.metal.MetalType;
import net.xelbayria.gems_realm.api.set.metal.VanillaMetalTypes;
import net.xelbayria.gems_realm.misc.HardcodedBlockType;

public class MetalTypeRegistry
extends BlockTypeRegistry<MetalType> {
    public static final MetalTypeRegistry INSTANCE = new MetalTypeRegistry();

    public MetalTypeRegistry() {
        super(MetalType.class, "metal_type");
    }

    public MetalType register(MetalType vanillaType) {
        return (MetalType)super.register((BlockType)vanillaType);
    }

    public MetalType getDefaultType() {
        return VanillaMetalTypes.IRON;
    }

    public Optional<MetalType> detectTypeFromBlock(class_2248 baseblock, class_2960 baseRes) {
        String metalName;
        int index;
        String blockPath = baseRes.method_12832();
        if (baseRes.method_12836().matches("tfc|afc") && blockPath.matches("metal/block/\\w+(?<!slab|stairs)")) {
            index = blockPath.lastIndexOf("/");
            metalName = blockPath.substring(index + 1);
            Optional block = class_7923.field_41175.method_17966(baseRes);
            boolean hasIngot = class_7923.field_41178.method_10250(new class_2960(baseRes.method_12836(), blockPath.replace("block", "ingot")));
            if (block.isPresent() && hasIngot) {
                return Optional.of(new MetalType(baseRes.method_45136(metalName), (class_2248)block.get()));
            }
        }
        if (baseRes.method_12836().matches("ms") && blockPath.matches("resources/[a-z]+_block")) {
            boolean isBlacklisted;
            index = blockPath.lastIndexOf("/");
            metalName = blockPath.substring(index + 1).replace("_block", "");
            class_2960 idBlockType = baseRes.method_45136(metalName);
            Optional block = class_7923.field_41175.method_17966(baseRes);
            boolean hasIngot = class_7923.field_41178.method_10250(new class_2960(baseRes.method_12836(), blockPath.replace("block", "ingot").replace("resources", "gem")));
            boolean bl = isBlacklisted = !HardcodedBlockType.BLACKLISTED_METALTYPES.contains(idBlockType.toString());
            if (block.isPresent() && hasIngot && isBlacklisted) {
                return Optional.of(new MetalType(idBlockType, (class_2248)block.get()));
            }
        }
        if (blockPath.matches("\\w+_block")) {
            Optional opt;
            boolean noGemType;
            String metalName2 = blockPath.replace("_block", "");
            class_2960 idBlockType = baseRes.method_45136(metalName2);
            boolean hasIngot = class_7923.field_41178.method_10250(new class_2960(baseRes.method_12836(), blockPath.replace("block", "ingot")));
            boolean noWoodType = !class_7923.field_41175.method_10250(new class_2960(baseRes.method_12836(), blockPath.replace("block", "log")));
            boolean bl = noGemType = !class_7923.field_41178.method_10250(new class_2960(baseRes.method_12836(), blockPath.replace("_block", "")));
            if (!this.valuesReg.containsKey(idBlockType) && hasIngot && noWoodType && noGemType && !HardcodedBlockType.BLACKLISTED_METALTYPES.contains(idBlockType.toString()) && !HardcodedBlockType.BLACKLISTED_MODS.contains(baseRes.method_12836()) && (opt = class_7923.field_41175.method_17966(baseRes)).isPresent()) {
                return Optional.of(new MetalType(idBlockType, (class_2248)opt.get()));
            }
        }
        return Optional.empty();
    }

    public MetalType.Finder addSimpleFinder(class_2960 metalTypeId) {
        MetalType.Finder finder = new MetalType.Finder(metalTypeId);
        this.addFinder((BlockType.SetFinder)finder);
        return finder;
    }

    public MetalType.Finder addSimpleFinder(String typeId) {
        return this.addSimpleFinder(new class_2960(typeId));
    }

    public MetalType.Finder addSimpleFinder(String namespace, String nameMetalType) {
        return this.addSimpleFinder(new class_2960(namespace, nameMetalType));
    }

    public int priority() {
        return 110;
    }
}

